<div class="mb-5">
    <x-admin.forms.label :for="'image-' . $language->id" :name="admin_trans('section_elements.' . $field->name)" :required="false" />

    @if (!empty($sectionElement) && !empty($sectionElement->translate($language->locale)->{$field->name}))
        <div class="image">
            <img
                src="{{ asset('storage/' . $sectionElement->translate($language->locale)->{$field->name}) }}"
                width="100"
                alt="Image"
                data-default-image="{{ asset('storage/admin/images/no_image.jpg') }}"
            >
        </div>
    @endif

    <div class="filePreview hidden">
        <input
            type="hidden"
            class="image"
            name="{{ 'fields[' . $language->locale . '][' . $field->name . ']' }}"
            value="{{ !empty($sectionElement) ? $sectionElement->translate($language->locale)->{$field->name} : null }}">
        <img src="" alt="Image">
    </div>

    <div class="parentImageUploadBtn mt-1">
        <button
            type="button"
            data-filemanagerroute="{{ route('elfinder.popup', 'image') }}"
            data-inputid="image"
            data-mimes="image"
            class="imageUploadBtn btn btn-icon btn-primary popup_selector"
        >
            <span class="tf-icons bx bx-image-add"></span>
        </button>

        @if (!empty($sectionElement->{$field->name}))
            <button
                type="button"
                class="imageDeleteBtn btn btn-icon btn-danger"
                data-deleteimageroute="{{ route('admin.section-elements.delete-image', [
                    'sectionElement' => $sectionElement,
                    'imageType' => $field->name,
                    'locale' => $language->locale
                ]) }}"
            >
                <span class="tf-icons bx bx-trash"></span>
            </button>
        @endif
    </div>
    <x-admin.forms.error name="{{ $field->name }}" />
</div>