<x-admin-layout>
	<x-slot:horizontalNav>
		@include('partials.admin.layout._horizontal-nav')
	</x-slot:horizontalNav>

	<x-admin.page-heading :spanContent="admin_trans('headings.sections') . ' /'" :content="$section->title" />

	<div id="breadcrumb" class="mb-4">
		<a href="{{ route('admin.home') }}">{{ admin_trans('home') }}</a> /
		<a href="{{ route('admin.' . $section->sectionable->getTable() . '.edit', $section->sectionable->id)
			}}">{{ admin_trans('headings.' . $section->sectionable::class) }}: {{ $section->sectionable->title }}</a> /
		<span>{{ admin_trans('sections.base_type') }}: {{ $section->title }}</span>
	</div>

	<div id="recordForm">
		<p>{{ admin_trans('sections.type') }}: {{ str()->of($section->sectionType->type)->title()->replace('_', ' ') }}</p>
		<form action="{{ route('admin.sections.update', $section->id) }}" method="POST" novalidate>
			@csrf
			@method('PUT')

			<x-admin.forms.entity.form-menu
				:route="route('admin.' . $section->sectionable->getTable() . '.edit', $section->sectionable->id)"
				:preview="true"
				:saveAndClose="true"
				:previewRoute="route('pages.show', $sectionableItemParent ? $sectionableItemParent->slug . '/' . $section->sectionable->slug : $section->sectionable->slug)" />

			@include('admin.sections._form')
		</form>
	</div>

</x-admin-layout>
