<x-admin-layout>
	<x-slot:horizontalNav>
		@include('partials.admin.layout._horizontal-nav')
	</x-slot:horizontalNav>

	<x-admin.page-heading :spanContent="admin_trans('headings.sections') . '/ '" :content="admin_trans('sections.new') . ' ' . $sectionType->type" />

	<div id="breadcrumb" class="mb-4">
		<a href="{{ route('admin.home') }}">{{ admin_trans('home') }}</a> /
		<a href="{{ route('admin.' . $parent->getTable() . '.edit', $parent->id) }}">{{ admin_trans('headings.' . $parent::class) }}: {{ $parent->title }}</a> /
		<span>{{ admin_trans('sections.new') }}</span>
	</div>

	<div id="recordForm">
		<form action="{{ route('admin.sections.store') }}" method="POST" novalidate>
			@csrf

			<x-admin.forms.entity.form-menu :route="route('admin.' . $parent->getTable() . '.edit', $parent->id)" :preview="false" :saveAndClose="true" />

			<div class="row">
				<div class="col-xl-9">
					<input type="hidden" name="sectionable_id" value="{{ $parent->id }}">
					<input type="hidden" name="sectionable_type" value="{{ $parent::class }}">
					<input type="hidden" name="sectionTypeId" value="{{ $sectionType->id }}">

					<div class="nav-align-top mb-4">
						<x-admin.errors-all />

						<ul id="language-tabs" class="nav nav-pills mb-2" role="tablist">
							@foreach($languages as $key => $language)
							<li class="nav-item">
								<button
									type="button"
									class="nav-link @if($key === 0) active @endif"
									role="tab"
									data-bs-toggle="tab"
									data-bs-target="#navs-section-top-{{ $language->code }}{{ !empty($section) ? '-' . $section->id : null }}"
									aria-controls="navs-section-top-{{ $language->code }}{{ !empty($section) ? '-' . $section->id : null }}"
									aria-selected="true"
								>
									{{$language->name}}
								</button>
							</li>
							@endforeach
						</ul>

						<div class="tab-content">
							@foreach($languages as $key => $language)
							<div
								class="tab-pane fade show @if($key === 0) active @endif"
								id="navs-section-top-{{ $language->code }}{{ !empty($section) ? '-' . $section->id : null }}"
								role="tabpanel"
							>
								@if ($sectionType->hasTitle())
									@include('admin.sections._form-partials._title')
								@endif

								@if ($sectionType->hasSubtitle())
									@include('admin.sections._form-partials._subtitle')
								@endif

								@if ($sectionType->hasDescription())
									@include('admin.sections._form-partials._description')
								@endif

								@if ($sectionType->hasTextContent())
									@include('admin.sections._form-partials._text-content')
								@endif

								@if ($sectionType->hasColor())
									@include('admin.sections._form-partials._color')
								@endif

								@if ($sectionType->hasImage())
									@include('admin.sections._form-partials._image')
								@endif

								@if ($sectionType->hasBackgroundImage())
									@include('admin.sections._form-partials._background-image')
								@endif

								@if ($sectionType->hasTitleImage())
									@include('admin.sections._form-partials._title-image')
								@endif

								@if ($sectionType->hasSearchTitle())
									@include('admin.sections._form-partials._search-title')
								@endif

								@if ($sectionType->hasHeaderBlockTitle())
									@include('admin.sections._form-partials._header-block-title')
								@endif

								@if ($sectionType->hasHeaderBlockSubtitle())
									@include('admin.sections._form-partials._header-block-subtitle')
								@endif

								@if ($sectionType->hasLeftColumnTextContent())
									@include('admin.sections._form-partials._left-column-text-content')
								@endif

								@if ($sectionType->hasRightColumnTextContent())
									@include('admin.sections._form-partials._right-column-text-content')
								@endif

								@if ($sectionType->hasOrganization())
									@include('admin.sections._form-partials._organization')
								@endif

								@if ($sectionType->hasIndustry())
									@include('admin.sections._form-partials._industry')
								@endif

								@if ($sectionType->hasSolution())
									@include('admin.sections._form-partials._solution')
								@endif

								@if ($sectionType->hasProducts())
									@include('admin.sections._form-partials._products')
								@endif

								@if ($sectionType->hasLocation())
									@include('admin.sections._form-partials._location')
								@endif

								@if ($sectionType->hasWebsite())
									@include('admin.sections._form-partials._website')
								@endif

								@if ($sectionType->hasAuthor())
									@include('admin.sections._form-partials._author')
								@endif

								@if ($sectionType->hasPosition())
									@include('admin.sections._form-partials._position')
								@endif

								@if ($sectionType->hasButtonText())
									@include('admin.sections._form-partials._button-text')
								@endif

								@if ($sectionType->hasButtonLink())
									@include('admin.sections._form-partials._button-link')
								@endif

								@if ($sectionType->hasButtonLeftText())
									@include('admin.sections._form-partials._button-left-text')
								@endif

								@if ($sectionType->hasButtonLeftLink())
									@include('admin.sections._form-partials._button-left-link')
								@endif

								@if ($sectionType->hasButtonCenterText())
									@include('admin.sections._form-partials._button-center-text')
								@endif

								@if ($sectionType->hasButtonCenterLink())
									@include('admin.sections._form-partials._button-center-link')
								@endif

								@if ($sectionType->hasButtonRightText())
									@include('admin.sections._form-partials._button-right-text')
								@endif

								@if ($sectionType->hasButtonRightLink())
									@include('admin.sections._form-partials._button-right-link')
								@endif
							</div>
							@endforeach
						</div>
					</div>
				</div>

				<div class="col-xl-3 mt-5">
					<section class="card mb-4">
						<h5 class="card-header">{{ str()->title(admin_trans('option_panel')) }}</h5>

						@if ($sectionType->type === 'cards' || $sectionType->type === 'cards_full_width')
							<div class="card-body">
								<x-admin.forms.select-page-type :pageTypes="$pageTypes" :page="$section ?? null" />

								<div class="mb-3">
									<x-admin.forms.label for="number_items" :name="admin_trans('sections.number_items')" :required="false" />
									<x-admin.forms.input
										id="number_items"
										type="number"
										min="1"
										max="12"
										name="number_items"
										:value="old('number_items', !empty($section) ? $section->number_items : null) ?? 1"
									/>
									<x-admin.forms.error name="number_items" />
								</div>
							</div>
						@endif

						<div class="card-body">
							{{-- <input type="checkbox" name="is_active" id="is_active" class="form-check-input">
							<x-admin.forms.label for="is_active" name="is_active" :required="false" />
							<x-admin.forms.error name="is_active" /> --}}

							<x-admin.forms.entity.form-switch name="is_active" :isRecordActive="$section->is_active ?? false" />

							<x-admin.forms.entity.form-switch name="is_in_wrapper" :isRecordActive="$section->is_in_wrapper ?? false" />
						</div>
					</section>

					<x-admin.forms.cover-image :entity="$section ?? null" coverImageDeleteRoute="admin.sections.delete-cover-image" />
				</div>
			</div>
		</form>
	</div>
</x-admin-layout>