<input type="hidden" name="sectionable_id" value="{{ $section->sectionable->id }}">
<input type="hidden" name="sectionable_type" value="{{ $section->sectionable::class }}">
{{-- <input type="hidden" name="edit_route" value="admin.sections"> --}}

<div class="row">
	<div class="col-xl-9">
		<div class="nav-align-top mb-4">
			<x-admin.errors-all />

			<ul id="language-tabs" class="nav nav-pills mb-2" role="tablist">
				@foreach($languages as $key => $language)
				<li class="nav-item">
					<button
						type="button"
						class="nav-link @if($key === 0) active @endif"
						role="tab"
						data-bs-toggle="tab"
						data-bs-target="#navs-section-top-{{ $language->code }}{{ !empty($section) ? '-' . $section->id : null }}"
						aria-controls="navs-section-top-{{ $language->code }}{{ !empty($section) ? '-' . $section->id : null }}"
						aria-selected="true"
					>
						{{ $language->name }}
					</button>
				</li>
				@endforeach
			</ul>

			<div class="tab-content">
				@foreach($languages as $key => $language)
				<div
					class="tab-pane fade show @if($key === 0) active @endif"
					id="navs-section-top-{{ $language->code }}{{ !empty($section) ? '-' . $section->id : null }}"
					role="tabpanel"
				>
						@if (!empty($section) && $section->typeHasTitle())
							@include('admin.sections._form-partials._title')
						@endif

						@if (!empty($section) && $section->typeHasSubtitle())
							@include('admin.sections._form-partials._subtitle')
						@endif

						@if (!empty($section) && $section->typeHasDescription())
							@include('admin.sections._form-partials._description')
						@endif

						@if (!empty($section) && $section->typeHasColor())
							@include('admin.sections._form-partials._color')
						@endif

						@if (!empty($section) && $section->typeHasImage())
							@include('admin.sections._form-partials._image')
						@endif

						@if (!empty($section) && $section->typeHasBackgroundImage())
							@include('admin.sections._form-partials._background-image')
						@endif

						@if (!empty($section) && $section->typeHasTitleImage())
							@include('admin.sections._form-partials._title-image')
						@endif

						@if (!empty($section) && $section->typeHasVideo())
							@include('admin.sections._form-partials._video')
						@endif

						@if (!empty($section) && $section->typeHasLink())
							@include('admin.sections._form-partials._link')
						@endif

						@if (!empty($section) && $section->typeHasSearchTitle())
							@include('admin.sections._form-partials._search-title')
						@endif

						@if (!empty($section) && $section->typeHasHeaderBlockTitle())
							@include('admin.sections._form-partials._header-block-title')
						@endif

						@if (!empty($section) && $section->typeHasHeaderBlockSubtitle())
							@include('admin.sections._form-partials._header-block-subtitle')
						@endif

						@if (!empty($section) && $section->typeHasTextContent())
							@include('admin.sections._form-partials._text-content')
						@endif

						@if (!empty($section) && $section->typeHasLeftColumnTextContent())
							@include('admin.sections._form-partials._left-column-text-content')
						@endif

						@if (!empty($section) && $section->typeHasRightColumnTextContent())
							@include('admin.sections._form-partials._right-column-text-content')
						@endif

						@if (!empty($section) && $section->typeHasOrganization())
							@include('admin.sections._form-partials._organization')
						@endif

						@if (!empty($section) && $section->typeHasIndustry())
							@include('admin.sections._form-partials._industry')
						@endif

						@if (!empty($section) && $section->typeHasSolution())
							@include('admin.sections._form-partials._solution')
						@endif

						@if (!empty($section) && $section->typeHasProducts())
							@include('admin.sections._form-partials._products')
						@endif

						@if (!empty($section) && $section->typeHasLocation())
							@include('admin.sections._form-partials._location')
						@endif

						@if (!empty($section) && $section->typeHasWebsite())
							@include('admin.sections._form-partials._website')
						@endif

						@if (!empty($section) && $section->typeHasAuthor())
							@include('admin.sections._form-partials._author')
						@endif

						@if (!empty($section) && $section->typeHasPosition())
							@include('admin.sections._form-partials._position')
						@endif

						@if (!empty($section) && $section->typeHasButtonText())
							@include('admin.sections._form-partials._button-text')
						@endif

						@if (!empty($section) && $section->typeHasButtonLink())
							@include('admin.sections._form-partials._button-link')
						@endif

						@if (!empty($section) && $section->typeHasButtonLeftText())
							@include('admin.sections._form-partials._button-left-text')
						@endif

						@if (!empty($section) && $section->typeHasButtonLeftLink())
							@include('admin.sections._form-partials._button-left-link')
						@endif

						@if (!empty($section) && $section->typeHasButtonCenterText())
							@include('admin.sections._form-partials._button-center-text')
						@endif

						@if (!empty($section) && $section->typeHasButtonCenterLink())
							@include('admin.sections._form-partials._button-center-link')
						@endif

						@if (!empty($section) && $section->typeHasButtonRightText())
							@include('admin.sections._form-partials._button-right-text')
						@endif

						@if (!empty($section) && $section->typeHasButtonRightLink())
							@include('admin.sections._form-partials._button-right-link')
						@endif
				</div>
				@endforeach

				@if ($section->sectionType->type === 'image_gallery')
					@include('admin.sections._form-partials._gallery')
				@endif
			</div>
		</div>

		@if (!empty($section) && $section->sectionType->sectElType)
			<x-admin.nestable-section-elements-list :section="$section" />
		@endif
	</div>

	<div class="col-xl-3 mt-5">
		<section class="card mb-4">
			<h5 class="card-header">{{ str()->title(admin_trans('option_panel')) }}</h5>

			@if ($section->sectionType->type === 'cards' || $section->sectionType->type === 'cards_full_width')
				<div class="card-body">
					<x-admin.forms.select-page-type :pageTypes="$pageTypes" :page="$section" />

					<div class="mb-3">
						<x-admin.forms.label for="number_items" :name="admin_trans('sections.number_items')" :required="false" />
						<x-admin.forms.input
							id="number_items"
							type="number"
							min="1"
							max="12"
							name="number_items"
							:value="old('number_items', !empty($section) ? $section->number_items : null) ?? 1"
						/>
						<x-admin.forms.error name="number_items" />
					</div>
				</div>
			@endif

			<div class="card-body">
				<x-admin.forms.entity.form-switch name="is_active" :isRecordActive="$section->is_active ?? false" />

				<x-admin.forms.entity.form-switch name="is_in_wrapper" :isRecordActive="$section->is_in_wrapper ?? false" />
			</div>
		</section>

		<x-admin.forms.cover-image :entity="$section ?? null" coverImageDeleteRoute="admin.sections.delete-cover-image" />
	</div>
</div>