<div class="mb-5">
    <x-admin.forms.label :for="'title-image-' . $language->id" :name="admin_trans('sections.title_image')" :required="false" />

    <div class="image">
        @if (!empty($section) && !empty($section->title_image))
            <img src="{{ asset('storage/' . $section->title_image) }}" width="100" alt="Image" data-default-image="{{ asset('storage/admin/images/no_image.jpg') }}">
        @endif
    </div>

    <div class="filePreview hidden">
        <input type="hidden" class="image" name="{{ 'fields[' . $language->locale . '][title_image]' }}" value="{{ !empty($section) ? $section->title_image : null }}">
        <img src="" alt="Image">
    </div>

    <div class="parentImageUploadBtn mt-1">
        <button
            type="button"
            data-filemanagerroute="{{ route('elfinder.popup', 'image') }}"
            data-inputid="title_image"
            data-mimes="image"
            class="imageUploadBtn btn btn-icon btn-primary popup_selector"
        >
            <span class="tf-icons bx bx-image-add"></span>
        </button>

        @if (!empty($section) && !empty($section->title_image))
            <button
                type="button"
                class="imageDeleteBtn btn btn-icon btn-danger"
                data-deleteimageroute="{{ route('admin.sections.delete-image', ['section' => $section, 'locale' => $language->locale, 'imageType' => 'title_image']) }}"
            >
                <span class="tf-icons bx bx-trash"></span>
            </button>
        @endif
    </div>
    <x-admin.forms.error name="title_image" />
</div>