<div class="mb-5">
    <x-admin.forms.label :for="'image-' . $language->id" :name="admin_trans('sections.image')" :required="false" />

    <div class="image">
        @if (!empty($section->image))
            <img src="{{ asset('storage/' . $section->image) }}" width="100" alt="Image" data-default-image="{{ asset('storage/admin/images/no_image.jpg') }}">
        @endif
    </div>

    <div class="filePreview hidden">
        <input type="hidden" class="image" name="{{ 'fields[' . $language->locale . '][image]' }}" value="{{ !empty($section) ? $section->image : null }}">
        <img src="" alt="Image">
    </div>

    <div class="parentImageUploadBtn mt-1">
        <button
            type="button"
            data-filemanagerroute="{{ route('elfinder.popup', 'image') }}"
            data-inputid="image"
            data-mimes="image"
            class="imageUploadBtn btn btn-icon btn-primary popup_selector"
        >
            <span class="tf-icons bx bx-image-add"></span>
        </button>

        @if (!empty($section->image))
            <button
                type="button"
                class="imageDeleteBtn btn btn-icon btn-danger"
                data-deleteimageroute="{{ route('admin.sections.delete-image', ['section' => $section, 'locale' => $language->locale, 'imageType' => 'image']) }}"
            >
                <span class="tf-icons bx bx-trash"></span>
            </button>
        @endif
    </div>
    <x-admin.forms.error name="image" />
</div>