<section class="container-xxl flex-grow-1 p-0">
    <h3>Images</h3>

    <div
        id="imagesGallery"
        class="row mb-5"
        data-parentid="{{ $section->id }}"
        data-setroute="{{ route('admin.images.change-order') }}"
        data-getroute="{{ route('admin.images.get-order') }}"
    >
        @forelse ($sectionImages as $image)
            <section
                class="galleryImgSection col-md-3 col-lg-3 mb-4"
                data-id="{{ $image->id }}"
            >
                <div class="card h-100 handle">
                    <div class="position-absolute top-0 end-0 p-2 d-flex justify-content-end gap-2">
                        <a
                            href="{{ route('admin.images.edit', [$image, 'parentPath' => 'admin.sections.edit', 'parentId' => $section->id]) }}"
                            class="btn btn-icon btn-info"
                        >
                            <span class="tf-icons bx bx-pencil bx-22px"></span>
                        </a>
                        <button
                            type="button"
                            class="galleryImgDeleteBtns btn btn-icon btn-danger"
                            data-route="{{ route('admin.images.destroy', $image->id) }}"
                        >
                            <span class="tf-icons bx bx-trash bx-22px"></span>
                        </button>
                    </div>
                    <img src="{{ asset('storage/' . $image->path) }}" class="card-img-top" alt="{{ $image->alt }}">
                    <div class="card-body">
                        <h5 class="card-title">title: {{ $image->title }}</h5>
                        <p class="card-text">description: {{ $image->description }}</p>
                        <p class="card-text">alt: {{ $image->alt }}</p>
                    </div>
                </div>
            </section>
        @empty
            No images
        @endforelse
    </div>
</section>

<button
    type="button"
    id="galleryImgUploadBtn"
    data-filemanagerroute="{{ route('elfinder.popup', 'gallery_image') }}"
    data-uploadimageroute="{{ route('admin.sections.upload-image', $section) }}"
    data-inputid="gallery_image"
    data-mimes="image"
    class="btn btn-icon btn-primary popup_selector"
>
    <span class="tf-icons bx bx-image-add"></span>
</button>
<input type="hidden" id="gallery_image" name="gallery_image" value="">