<div class="mb-5">
    <x-admin.forms.label :for="'color-' . $language->id" :name="admin_trans('sections.color')" :required="false" />
    <select
        id="'color-' . {{ $language->id }}"
        name="{{ 'fields[' . $language->locale . '][color]' }}"
        class="form-select"
        aria-label="Select color"
    >
        <option value="">{{ admin_trans('sections.select_color') }}</option>
        @foreach ($sectionColors as $color)
            <option
                value="{{ $color->id }}"
                {{ old('fields.' . $language->locale . '.color', !empty($section) ? $section->translate($language->locale)->color : 0) == $color->id ? 'selected' : '' }}

            >{{ admin_trans('sections.colors.' . $color->name) }}</option>
        @endforeach
    </select>
    <x-admin.forms.error :name="$language->locale . '.color'" />
</div>