<div class="mb-5">
    <x-admin.forms.label :for="'background-image-' . $language->id" :name="admin_trans('sections.background_image')" :required="false" />

    <div class="image">
        @if (!empty($section) && !empty($section->background_image))
            <img src="{{ asset('storage/' . $section->background_image) }}" width="100" alt="Image" data-default-image="{{ asset('storage/admin/images/no_image.jpg') }}">
        @endif
    </div>

    <div class="filePreview hidden">
        <input type="hidden" class="image" name="{{ 'fields[' . $language->locale . '][background_image]' }}" value="{{ !empty($section) ? $section->background_image : null }}">
        <img src="" alt="Image">
    </div>

    <div class="parentImageUploadBtn mt-1">
        <button
            type="button"
            data-filemanagerroute="{{ route('elfinder.popup', 'image') }}"
            data-inputid="background_image"
            data-mimes="image"
            class="imageUploadBtn btn btn-icon btn-primary popup_selector"
        >
            <span class="tf-icons bx bx-image-add"></span>
        </button>

        @if (!empty($section) && !empty($section->background_image))
            <button
                type="button"
                class="imageDeleteBtn btn btn-icon btn-danger"
                data-deleteimageroute="{{ route('admin.sections.delete-image', ['section' => $section, 'locale' => $language->locale, 'imageType' => 'background_image']) }}"
            >
                <span class="tf-icons bx bx-trash"></span>
            </button>
        @endif
    </div>
    <x-admin.forms.error name="background_image" />
</div>