<div class="row">
	<div class="col-xl-9">
		<div class="nav-align-top mb-4">
			<x-admin.errors-all />

			<ul id="language-tabs" class="nav nav-pills mb-2" role="tablist">
				@foreach($languages as $key => $language)
				<li class="nav-item">
					<button
						type="button"
						class="nav-link @if($key === 0) active @endif"
						role="tab"
						data-bs-toggle="tab"
						data-bs-target="#navs-top-{{ $language->code }}{{ !empty($image) ? '-' . $image->id : null }}"
						aria-controls="navs-top-{{ $language->code }}{{ !empty($image) ? '-' . $image->id : null }}"
						aria-selected="true"
					>
						{{$language->name}}
					</button>
				</li>
				@endforeach
			</ul>
			<div class="tab-content">
				@foreach($languages as $key => $language)
					<div
						class="tab-pane fade show @if($key === 0) active @endif"
						id="navs-top-{{ $language->code }}{{ !empty($image) ? '-' . $image->id : null }}"
						role="tabpanel"
					>
						<div class="mb-3">
							<x-admin.forms.label :for="'title-' . $language->id" :name="admin_trans('page.title')" :required="false" />
							<x-admin.forms.input
								:id="'title-' . $language->id"
								:name="$language->locale . '[title]'"
								:value="!empty($image->translate($language->locale)->title) ? $image->translate($language->locale)->title : null"
								:required="true"
							/>
							<x-admin.forms.error :name="'fields.' . $language->locale . '.title'" />
						</div>

						<div class="mb-3">
							<x-admin.forms.label :for="'description-' . $language->id" :name="admin_trans('page.description')" :required="false" />
							<x-admin.forms.input
								:id="'description-' . $language->id"
								:name="$language->locale . '[description]'"
								:value="!empty($image->translate($language->locale)->description) ? $image->translate($language->locale)->description : null"
								:required="false"
							/>
							<x-admin.forms.error :name="'fields.' . $language->locale . '.description'" />
						</div>

						<div class="mb-3">
							<x-admin.forms.label :for="'alt-' . $language->id" :name="admin_trans('images.alt')" :required="false" />
							<x-admin.forms.input
								:id="'alt-' . $language->id"
								:name="$language->locale . '[alt]'"
								:value="!empty($image->translate($language->locale)->alt) ? $image->translate($language->locale)->alt : null"
								:required="false"
							/>
							<x-admin.forms.error :name="'fields.' . $language->locale . '.alt'" />
						</div>
					</div>
				@endforeach
			</div>
		</div>
	</div>
</div>