import { CONSTANTS as c, functions as f } from "../helpers";
export default class Tab {
    constructor(options) {
        this.$section = options.section;
        this.$items = this.$section.find(".table .u-box");
        this.$tabs = this.$section.find(options.dataLinkSelector);
        this.$contents = this.$section.find(options.dataContentSelector);
    }
    init() {
        let self = this;
        self.$tabs.click(function (e) {
            let tab = $(this);
            const $item = tab.closest(".u-box");
            let dataId = tab.attr("data-tab");
            let $content = self.$section.find(`[data-content=${dataId}]`);
            $item.siblings().find(".u-box").removeClass("active");
            $item.toggleClass("active");
        });
        return self;
    }
}
