import Core from './Core';
import { CONSTANTS as c, functions as f } from '../helpers';
// import AutoNumeric from 'autonumeric';

export default class InputField {
  constructor(el) {
    this.$el = el;
    this.value = this.$el.val();
    this.$form = this.$el.closest('form');
    this.$formGroup = this.$el.closest('.form-group');
    this.$inputContainer = this.$el.closest('label');
    this.$listContainerNew = this.$formGroup.find('.file-list-new');
    this.fileListNew = [];
    this.$deleteBtns = this.$formGroup.find('.delete-file');
    this.$editBtns = this.$formGroup.find('.btn.edit-file-input-text');
    this.$confirmBtns = this.$formGroup.find('.btn.confirm-file-input-text');
    this.formatValue = undefined;
    this.formData = new FormData(this.$form[0]);
    this.errorMsg = Core.translations.error_latin_character
      ? Core.translations.error_latin_character
      : 'Please, use latin!';
  }

  init() {
    const self = this;
    if (self.value) {
      self.check();
    }
    let visited = false;
    if (self.$el.is('.numberMask')) {
      // this.formatValue = new AutoNumeric(self.$el[0], {
      //   minimumValue: 0,
      //   maximumValue: 9,
      //   decimalPlaces: 0,
      // });
    }
    if (!self.$el.is('[type="file"]')) {
      self.$el.on('input change', function (e) {
        self.check();
        self.$el.closest('.error').removeClass('error');
        if (self.$el.is('textarea')) {
          self.$el.css('height', '1px');
          self.$el.css('height', 5 + self.$el[0].scrollHeight + 'px');
        }
      });
    } else if (self.$el.is('[type="file"]')) {
      f.multipleEvents(self.$el[0], 'click dragstart dragover', function (e) {
        self.$inputContainer[0].classList.add('active');
      });
      f.multipleEvents(self.$el[0], 'dragleave dragend drop change', function (e) {
        self.$inputContainer[0].classList.remove('active');
      });
      self.$el.on('change', function (e) {
        console.log('🚀 ~ InputField ~ e:', e);
        self.fileListNew = [];
        const files = [...self.$el[0].files];
        files.forEach((file) => {
          self.fileListNew.push(file);
        });
        self.setFilesList();
      });
      self.$editBtns.on('click', function (e) {
        e.stopPropagation();
        const $input = $(this).closest('.file').find('input');
        $input.attr('readonly', false);
        $input.addClass('edit');
        $input.trigger('focus');
        $(this).siblings('.confirm-file-input-text').toggleClass('hidden');
        $(this).toggleClass('hidden');
      });
      self.$confirmBtns.on('click', function (e) {
        e.stopPropagation();
        const $confirmBtn = $(this);
        const $input = $(this).closest('.file').find('input');
        const url = $confirmBtn.data('url');
        const method = $confirmBtn.data('method');
        const data = { value: $input.val() };
        const $editBtn = $(this).siblings('.edit-file-input-text');

        $.ajax({
          url,
          method,
          headers: {
            'X-CSRF-TOKEN': Core.token,
          },
          data,
          dataType: 'json',
          beforeSend: function () {
            $confirmBtn.attr('disabled', true);
            self.setLoader();
          },
          success: function (response) {
            if (response.hasOwnProperty('redirect')) {
              window.location = response.redirect;
              return;
            }
            $.magnificPopup.close();
            self.setPopup(response);
          },
          error: function (jqXHR, textStatus, errorThrown) {
            console.log(
              '🚀 ~ InputField ~ jqXHR, textStatus, errorThrown:',
              jqXHR,
              textStatus,
              errorThrown
            );
            $.magnificPopup.close();
            if (!jqXHR?.responseJSON) return;
            self.setPopup(jqXHR?.responseJSON);
          },
          complete: function (data) {
            $confirmBtn.attr('disabled', false);
            $confirmBtn.toggleClass('hidden');
            $editBtn.toggleClass('hidden');
          },
        });
      });
      self.$deleteBtns.on('click', function (e) {
        e.stopPropagation();
        const $deleteBtn = $(this);
        const $file = $(this).closest('.file');
        const url = $deleteBtn.data('url');
        const method = $deleteBtn.data('method');

        $.ajax({
          url,
          method,
          headers: {
            'X-CSRF-TOKEN': Core.token,
          },
          dataType: 'json',
          beforeSend: function () {
            $deleteBtn.attr('disabled', true);
            self.setLoader();
          },
          success: function (response) {
            $file.remove();
            $.magnificPopup.close();
            self.setPopup(response);
          },
          error: function (jqXHR, textStatus, errorThrown) {
            console.log('🚀 ~ InputField ~ jqXHR:', jqXHR);
            $.magnificPopup.close();
            if (!jqXHR?.responseJSON) return;
            self.setPopup(jqXHR?.responseJSON);
          },
          complete: function (data) {
            $deleteBtn.attr('disabled', false);
          },
        });
      });
    }
    self.$el.on('focusin', function () {
      self.$el.addClass('active');
    });

    self.$el.on('focusout', function (e) {
      self.getValue();
      self.check();
      visited = true;
      self.$el.removeClass('active');
    });

    // if (
    //   !self.$el.is('[type="file"]') &&
    //   !self.$el.is('[type="checkbox"]') &&
    //   !self.$el.is('[type="radio"]')
    // ) {
    //   self.$el.on('input change', function (e) {
    //     self.preventCharacters();
    //   });
    // }
    return self;
  }
  setLoader() {
    $.magnificPopup.open({
      items: {
        src: `<div class="loader-wrapper"><span class="loader"></span></div>`,
        type: 'inline',
        showCloseBtn: false,
      },
    });
  }
  setPopup(response) {
    if (response.hasOwnProperty('redirect')) {
      window.location = response.redirect;
      return;
    }
    if (!response.message) return;
    let src = `<div class="popup-inline">`;
    if (response.message.title) {
      src += `<h3>${response.message.title}</h3>`;
    }
    if (response.message.subtitle) {
      src += `<p>${response.message.subtitle}</p>`;
    }
    if (response.message.closeBtn) {
      src += `<button class="btn btn-icon-only close-popup"
            type="button">Затвори</button>`;
    }
    src += `</div>`;
    $.magnificPopup.open({
      items: {
        src,
        type: 'inline',
      },
      callbacks: {
        open: function () {
          if (response.message.closeBtn) {
            const $closeBtn = $('.close-popup');
            $closeBtn.on('click', function () {
              $.magnificPopup.close();
            });
          }
        },
      },
    });
  }
  handleDelete(index = 0) {}
  setFilesList() {
    const self = this;
    self.$form.find('.file-list-new').remove();
    let content = `<ul class="file-list-new">`;
    self.fileListNew.forEach((addedFile, index) => {
      content += `
           <li>${addedFile.name}</li>
        `;
    });
    content += '</ul>';
    console.log('🚀 ~ InputField ~ setFilesList ~ content:', content);
    self.$inputContainer.append(content);
    console.log('🚀 ~ InputField ~ setFilesList ~  self.$inputContainer:', self.$inputContainer);
    return self;
  }

  preventCharacters() {
    const self = this;
    self.value = self.$el.val();
    const specials = /[^A-Za-z 0-9!?~@#\$%\^\&*\)\(\{\}\[\]\|\\+=,._-]/g;
    if (specials.test(self.value)) {
      self.$el.val('');
      self.renderError();
      setTimeout(function () {
        self.removeError();
      }, 5000);
    } else {
      self.removeError();
    }
  }
  getValue() {
    const self = this;
    self.value = self.$el.val();
    return self;
  }
  check() {
    const self = this;
    self.getValue();
    if (self.value) {
      self.$el.addClass('filled');
    } else {
      self.$el.removeClass('filled');
    }
    return self;
  }
  renderError() {
    const self = this;
    const $fieldFromGroup = self.$el.closest('.form-group');
    if ($fieldFromGroup.hasClass('error')) return;
    const $fieldError = $('<span class="error-msg"></span>');
    $fieldFromGroup.append($fieldError);
    $fieldFromGroup.addClass('error');
    $fieldError.append(self.errorMsg);
    return self;
  }
  removeError() {
    const self = this;
    self.$el.closest('.form-group').removeClass('error');
    self.$el.closest('.form-group').find('.error-msg').remove();
    return self;
  }
}
