import * as vendor from './vendors';
import * as helpers from './helpers';
import { controllers } from './controllers';
import { utilities } from './utilities';

const isDev = utilities.Core.isDev;

isDev ? console.time('content') : '';
isDev ? console.time('load') : '';
$(document).ready(function () {
  controllers.AnimationController.init();
  controllers.FormController.init();
  controllers.MagnificPopupController.init();
  controllers.HeaderController.init();
  controllers.FooterController.init();
  controllers.SwiperController.init();
  controllers.VideoController.init();
  controllers.LoadMoreController.init();
  controllers.ShowMoreController.init();
  controllers.MapController.init();

  isDev ? console.timeEnd('content') : '';
});
$(window).on('load', function () {
  isDev ? console.timeEnd('load') : '';
});


