import * as c from './constants';
const isDev = process.env.NODE_ENV === 'development';

export function calculateRem(pixels) {
  return pixels / (c.HTML_FONT_SIZE_PERCENT * 16);
}
$.fn.isInViewport = function () {
  var elementTop = $(this).offset().top;
  var elementBottom = elementTop + $(this).outerHeight();
  var viewportTop = $(window).scrollTop();
  var viewportBottom = viewportTop + $(window).height();
  return elementBottom > viewportTop && elementTop < viewportBottom;
};

export const multipleEvents = (element, eventNames, listener) => {
  const events = eventNames.split(' ');

  events.forEach((event) => {
    element.addEventListener(event, listener, false);
  });
};

export const toggle = (
  target,
  destinations,
  classToggle,
  globalHandler = true,
  renameTarget = null
) => {
  const $target = $(target);
  const $destinations = $(destinations.join());
  $target.on('click', function (e) {
    e.stopPropagation();
    $destinations.toggleClass(classToggle);
    $target.toggleClass(classToggle);
  });
  if (globalHandler) {
    $(document).click(function (e) {
      e.stopPropagation();
      let s2 = true;
      if ($target.is('.c-filter .btn.toggle')) {
        s2 = !$('.select2-container--open *').is(e.target);
      }
      if (!$destinations.is(e.target) && s2 && $destinations.has(e.target).length === 0) {
        $destinations.removeClass(classToggle);
        $target.removeClass(classToggle);
      }
    });
  }
};
export const renderPatients = (data, type = '') => {
  if (!data) return;
  const { patients, patientsHeader, minutes, minutesHeader, list } = data;
  const $patientsHeaderContainer = $('.part.patients .heading');
  const $patientsCountContainer = $('.part.patients .count');
  const $minutesHeaderContainer = $('.part.minutes .heading');
  const $minutesCountHeaderContainer = $('.part.minutes .count');
  const $listContainer = $('.c-list ul');
  const $btn = $('.info .btn');
  if (patients) {
    $patientsHeaderContainer.html(patientsHeader);
  }
  if (patientsHeader) {
    $patientsCountContainer.html(patients);
  }
  if (minutes) {
    $minutesHeaderContainer.html(minutesHeader);
  }
  if (minutesHeader) {
    $minutesCountHeaderContainer.html(minutes);
  }
  if (list) {
    $listContainer.html(list);
  }
  if (type) {
    $btn.remove();
  }
};

export const setMarginTop = () => {
  const headerHeight = $('#header').height();
  let top = `${(headerHeight + 40) / 10}` + 'rem';
  if (c.MQ_IS.md) {
    top = `${(headerHeight + 20) / 10}` + 'rem';
  }
  c.CSS_ROOT.style.setProperty('--main-margin-top', `${top}`);
  $('main').css('margin-top', top);
};

export const closeOnClickOutside = (ele, cb) => {
  document.addEventListener('click', (event) => {
    if (!ele.contains(event.target)) cb();
  });
};

export const openLoader = () => {
  if (!$.magnificPopup) return;
  $.magnificPopup.open({
    items: {
      src: `<div class="loader-wrapper"><span class="loader"></span></div>`,
      type: 'inline',
      showCloseBtn: false,
    },
  });
};
export const closeLoader = () => {
  if (!$.magnificPopup) return;
  $.magnificPopup.close();
};
export const isDeviceSizeSame = (sizeComparison) => {
  if (sizeComparison) {
    return true;
  } else {
    return false;
  }
};

export const onMagnificOpenCb = ($popup) => {
  const $closeBtn = $popup.find('.popup-close');
  $closeBtn.unbind('click');
  $closeBtn.on('click', function (e) {
    e.stopPropagation();
    $.magnificPopup.close();
  });
};
export const onMagnificCloseCb = ($popup) => {
  // $popup.removeClass('mfp-hide');
};
