import * as f from './functions';
import { throttle } from 'lodash-es';
export const CSS_ROOT = document.documentElement;
export const CSS_DOCUMENT_ROOT = getComputedStyle(CSS_ROOT);
export const isMacIos = /(Mac|iPhone|iPod|iPad)/i.test(navigator.platform);
export const isIOS = /(iPhone|iPod|iPad)/i.test(navigator.platform);
export const MQ = {
  desktop: CSS_DOCUMENT_ROOT.getPropertyValue('--desktop'),
  uhd: CSS_DOCUMENT_ROOT.getPropertyValue('--uhd'),
  qhd: CSS_DOCUMENT_ROOT.getPropertyValue('--qhd'),
  fhd: CSS_DOCUMENT_ROOT.getPropertyValue('--fhd'),
  xl: CSS_DOCUMENT_ROOT.getPropertyValue('--xl'),
  lg: CSS_DOCUMENT_ROOT.getPropertyValue('--lg'),
  md: CSS_DOCUMENT_ROOT.getPropertyValue('--md'),
  sm: CSS_DOCUMENT_ROOT.getPropertyValue('--sm'),
  xs: CSS_DOCUMENT_ROOT.getPropertyValue('--xs'),
};
export const MQ_IS = (function () {
  const _MQ_IS = {
    desktop: $(window).width() <= MQ.desktop,
    uhd: $(window).width() <= MQ.uhd,
    qhd: $(window).width() <= MQ.qhd,
    fhd: $(window).width() <= MQ.fhd,
    xl: $(window).width() <= MQ.xl,
    lg: $(window).width() <= MQ.lg,
    md: $(window).width() <= MQ.md,
    sm: $(window).width() <= MQ.sm,
    xs: $(window).width() <= MQ.xs,
  };
  $(window).on(
    'resize',
    throttle((num) => {
      _MQ_IS.desktop = $(window).width() <= MQ.desktop;
      _MQ_IS.uhd = $(window).width() <= MQ.uhd;
      _MQ_IS.qhd = $(window).width() <= MQ.qhd;
      _MQ_IS.fhd = $(window).width() <= MQ.fhd;
      _MQ_IS.xl = $(window).width() <= MQ.xl;
      _MQ_IS.lg = $(window).width() <= MQ.lg;
      _MQ_IS.md = $(window).width() <= MQ.md;
      _MQ_IS.sm = $(window).width() <= MQ.sm;
      _MQ_IS.xs = $(window).width() <= MQ.xs;
    }, 0)
  );
  return _MQ_IS;
})();
export const HTML_FONT_SIZE_PERCENT = CSS_DOCUMENT_ROOT.getPropertyValue(
  '--font-size-html-percent'
);

export const TR_SPEED = {
  slow: parseInt(CSS_DOCUMENT_ROOT.getPropertyValue('--speed-slow'), 10),
  normal: parseInt(CSS_DOCUMENT_ROOT.getPropertyValue('--speed-normal'), 10),
  fast: parseInt(CSS_DOCUMENT_ROOT.getPropertyValue('--speed-fast'), 10),
};

export const LOCALES = {
  bg: 'bg',
  en: 'en',
};

export const TRANSLATIONS = {};
// f.setMarginTop();
// $(window).resize(
//     _.throttle((e) => {
//         f.setMarginTop();
//     }, 250)
// );
