import { utilities } from "../utilities";
import { CONSTANTS } from "../helpers";
import { throttle } from 'lodash-es';

class ShowMoreController {
    init() {
        $.each($('[data-show-more]'), function(index, value) {
            const $btn = $(value);
            const $showText = $btn.find('[data-show-text]');
            const $hideText = $btn.find('[data-hide-text]');
            const $elements = $btn.closest('section').find('[data-element]');
            let isHidden = true;
            if( !$elements.length ) return;
            const $elementsAfterEight = $elements.slice(8);
            if( !$elementsAfterEight.length ) return;
            $btn.on('click', function (e) {
                e.stopPropagation();

                if(isHidden) {
                    $elementsAfterEight.removeClass('md:[&:nth-child(n+9)]:hidden');
                    $showText.hide();
                    $hideText.show();
                } else {
                    $elementsAfterEight.addClass('md:[&:nth-child(n+9)]:hidden');
                    $showText.show();
                    $hideText.hide();
                }
                isHidden = !isHidden;
            });
            $(window).on('resize', throttle(function () {
                if(!CONSTANTS.MQ_IS.md) {
                    $elementsAfterEight.addClass('md:[&:nth-child(n+9)]:hidden');
                    $showText.show();
                    $hideText.hide();
                    isHidden = true;
                }
            }, CONSTANTS.TR_SPEED.fast));
        });


    }
}
export const controller = new ShowMoreController();
