import { utilities } from '../utilities';
import { CONSTANTS as c, functions as f } from '../helpers';
import { debounce, throttle } from 'lodash-es';
class MagnificPopupController {
  constructor() {
    this.windowWidth = window.innerWidth;
  }
  init() {
    let self = this;
    $('.popup-open')
      .toArray()
      .forEach((el) => {
        const $el = $(el);
        const $root = $el.closest('[data-popup-root]');
        const index = $root.data('popup-index');
        let $popupContent;
        if ($root.is('[class*=popup-testimonial]')) {
          $popupContent = $('#popup-testimonial-' + index);
        }
        $el.on('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          $.magnificPopup.open({
            items: {
              src: $popupContent,
            },
            showCloseBtn: false,
            callbacks: {
              open: function () {
                f.onMagnificOpenCb($popupContent);
              },
              close: function () {
                f.onMagnificCloseCb($popupContent);
              },
            },
          });
        });
      });
    self.setSeeMoreBtnState(false);
    $(window).on('resize', throttle(self.setSeeMoreBtnState, 300));
  }
  setSeeMoreBtnState(isOnResizeCb = true) {
    const self = this;

    $('[class*=popup-testimonial]').each(function (index, el) {
      const $el = $(el);
      const $popupContent = $el.find('.content');
      const $btnShowMore = $el.find('.popup-open');
      if (isOnResizeCb && window.innerWidth === self.windowWidth) return;
      utilities.Core.isDev ? console.log($popupContent.height()) : '';
      if (+Math.round($popupContent.height()) >= 555) {
        $popupContent.addClass('line-clamp-[18]');
        $btnShowMore.show();
      } else {
        $popupContent.removeClass('line-clamp-[18]');
        $btnShowMore.hide();
      }
    });
    self.windowWidth = window.innerWidth;
    return self;
  }
}
export const controller = new MagnificPopupController();
