import { utilities } from '../utilities';
import { CONSTANTS as c, functions as f } from '../helpers';
import { controller as AnimationController } from './AnimationController';

class LoadMoreController {
  init() {
    $.each($('[data-load-more]'), function (index, gallery) {
      const $gallery = $(gallery);
      const $content = $gallery.find('[data-content]');
      const $btn = $gallery.find('[data-next-page]');
      $btn.on('click', () => {
        const url = $gallery.attr('data-url');
        const method = $gallery.attr('data-method');
        $.ajax({
          url,
          method,
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
          },
          beforeSend: function () {
            f.openLoader();
          },
          success: function (res) {
            if (!res) return;
            const data = { ...res.data };
            if (!data) return;
            let items = data.items;
            let $items = $(items);
            const nextPge = data.page;

            if ($items.length) {
              $items.each(function (index, item) {
                if (index === 0) {
                  console.log('🚀 ~ LoadMoreController ~ item:', item);
                  item.dataset.scrollTo = true;
                }
              });
              $content.append($items);
            }

            if (!nextPge) {
              $btn.hide();
            } else {
              const newUrl = new URL(url);
              newUrl.searchParams.set('page', nextPge);
              $gallery.attr('data-url', newUrl);
            }
            setTimeout(() => {
              $gallery.find('[data-scroll-to]').last()[0].scrollIntoView({
                behavior: 'smooth',
                block: 'start',
              });
              const $els = $('[data-load-more] [data-scroll-to]').last().prev().nextAll();
              if(!$els.length) return;
              AnimationController.setBatchAnimations($els);
            }, 0);
          },
          error: function (jqXHR, textStatus, errorThrown) {},
          complete: function (data) {
            f.closeLoader();
          },
        });
      });
    });
  }
}
export const controller = new LoadMoreController();
