import { CONSTANTS as c, functions as f } from '../helpers';
import { utilities } from '../utilities';
import { throttle } from 'lodash-es';
import Core from '../utilities/Core';
class HeaderController {
  constructor() {
    this.$navWrapper = $('header .nav-wrapper');
    this.$nav = this.$navWrapper.find('nav.nav');
    this.$navLinks = this.$nav.find(' > ul');
    this.$input = this.$nav.find('input');
    this.$btnCloseContent = $('[data-search-close]');
    this.$btnOpenContent = $('[data-search-open]');
    this.$searchContent = $('[data-search-content]');
    this.$mobileMenuToggle = $('.btn.mobile-menu-toggle');
    this.windowSizeIsDesktop;
  }
  init() {
    const self = this;
    if (!self.$nav.length > 0) return;
    self.windowSizeIsDesktop = !c.MQ_IS.lg;
    self.setNavDropdowns();
    self.setSearch();
    self.setMobileNavState();

    self.onWindowResize();

    return self;
  }
  setMobileNavState() {
    const self = this;
    self.$mobileMenuToggle.on('click', function () {
      $(this).toggleClass('isActive');
      if (self.$searchContent.hasClass('isActive')) {
        $(this).addClass('invisible');
      }
      self.$navWrapper.toggleClass('isActive');
      $('body').toggleClass('no-scroll');
    });

    return self;
  }
  setNavDropdowns() {
    const self = this;

    $.each($('[data-dropdown]'), function (index, el) {
      const $dropdown = $(el);
      const $dropdownIcon = $dropdown.find('.icon-chevron-down');
      const $content = $dropdown.find('[data-dropdown-content]').first();
      const $solutionLink = $dropdown.find('[data-solution-link] span');
      $dropdown.on('click', function (event) {
        // event.stopPropagation();
        if (!c.MQ_IS.lg) return;
        if ($content[0].contains(event.target)) return;
        $dropdown.toggleClass('isActive');
      });
      $dropdownIcon.on('click', function (event) {
        event.preventDefault();
        event.stopPropagation();
        if (!c.MQ_IS.lg) return;
        $dropdownIcon.toggleClass('isActive');
        $dropdown.toggleClass('isActive');
      });
      $solutionLink.on('click', function (event) {
        console.log('🚀 ~ HeaderController ~ event:', event);
        // event.preventDefault();
        // event.stopPropagation();
        if (c.MQ_IS.lg) {
          self.$mobileMenuToggle.removeClass('isActive');
          self.$navWrapper.removeClass('isActive');
          $('body').removeClass('no-scroll');
        }
      });
      // document.addEventListener('click', (event) => {
      //   if (c.MQ_IS.md) return;
      //   if (!$dropdown[0].contains(event.target) && !$content[0].contains(event.target)) {
      //     if ($dropdown.hasClass('isActive')) $dropdown.removeClass('isActive');
      //   }
      // });
    });

    return self;
  }
  setSearch() {
    const self = this;
    self.$btnOpenContent.on('click', function () {
      self.$searchContent.addClass('isActive');
      self.$input[0].focus();
      self.$btnOpenContent.addClass('hidden');
      if (!c.MQ_IS.lg) {
        self.$navLinks.addClass('invisible');
      } else {
        self.$mobileMenuToggle.addClass('invisible');
      }
    });
    self.$btnCloseContent.on('click', function () {
      self.$input[0].blur();
      self.$searchContent.removeClass('isActive');
      self.$btnOpenContent.removeClass('hidden');
      if (!c.MQ_IS.lg) {
        self.$navLinks.removeClass('invisible');
      } else {
        self.$mobileMenuToggle.removeClass('invisible');
      }
    });

    return self;
  }

  onWindowResize() {
    const self = this;
    $(window).on(
      'resize',
      throttle(function () {
        if (
          (self.windowSizeIsDesktop && c.MQ_IS.lg) ||
          (!self.windowSizeIsDesktop && !c.MQ_IS.lg)
        ) {
          self.resetNavState();
        }
        self.windowSizeIsDesktop = !c.MQ_IS.lg;
      }, 200)
    );
    return self;
  }
  resetNavState() {
    const self = this;
    Core.isDev ?? console.log('resetNavState');
    $('header [data-dropdown]').removeClass('isActive');
    $('header .icon-chevron-down').removeClass('isActive');
    $('header [data-dropdown-content]').removeClass('isActive');
    self.$navWrapper.removeClass('isActive');
    self.$mobileMenuToggle.removeClass('isActive');
    self.$searchContent.removeClass('isActive');
    self.$btnOpenContent.removeClass('hidden');
    self.$input[0].blur();
    self.$navLinks.removeClass('invisible');
    self.$mobileMenuToggle.removeClass('invisible');
    $('body').removeClass('no-scroll');
    return self;
  }
}
export const controller = new HeaderController();
