"use strict";

import EntityForm from "./entity-form";

import "tinymce/tinymce";
import "tinymce/skins/ui/oxide/skin.min.css";
import "tinymce/icons/default/icons";
import "tinymce/themes/silver/theme";
import "tinymce/plugins/image/plugin.min";
import "tinymce/plugins/link/plugin.min";
import "tinymce/plugins/code/plugin.min";
import "tinymce/plugins/lists/plugin.min";
import "tinymce/plugins/media/plugin.min";
import "tinymce/plugins/table/plugin.min";
import "tinymce/plugins/fullscreen/plugin.min";
import "tinymce/models/dom/model";

function elFinderBrowser(callback, value, meta) {
    const txtArea = tinymce.activeEditor.getElement();

    tinymce.activeEditor.windowManager.openUrl({
        title: "File Manager",
        url: $(txtArea).data("editor-route"),
        /**
         * On message will be triggered by the child window
         *
         * @param dialogApi
         * @param details
         * @see https://www.tiny.cloud/docs/ui-components/urldialog/#configurationoptions
         */
        onMessage: function (dialogApi, details) {
            if (details.mceAction === "fileSelected") {
                const file = details.data.file;

                // Make file info
                const info = file.name;

                // Provide file and text for the link dialog
                if (meta.filetype === "file") {
                    callback(file.url, { text: info, title: info });
                }

                // Provide image and alt text for the image dialog
                if (meta.filetype === "image") {
                    callback(file.url, { alt: info });
                }

                // Provide alternative source and posted for the media dialog
                if (meta.filetype === "media") {
                    callback(file.url);
                }

                dialogApi.close();
            }
        },
    });
}

if ($(".tinyMCE").length) {
    tinymce.init({
        selector: "textarea.tinyMCE",
        theme: "silver",
        license_key: "gpl",
        branding: false,
        promotion: false,
        skin: false,
        content_css: false,
        content_style: "body { font-family: Arial, sans-serif; font-size: 14px; }",
        plugins: "link image code lists media table fullscreen",
        toolbar1: "undo redo | code | cut copy paste pastetext pasteword",
        toolbar2: "bold italic underline superscript subscript | numlist bullist | outdent indent | blockquote | alignleft aligncenter alignright justify| link unlink | media image table hr",
        toolbar3: "styles | fontfamily | fontsize | fullscreen",
        menubar: "edit format insert view",
        font_size_formats: "8px 10px 12px 14px 16px 18px 24px 36px",
        file_picker_callback: elFinderBrowser,
        relative_urls: false,
        remove_script_host: false,
        document_base_url: "{{ url('/') }}/",
    });
}
