"use strict";

import Form from "./form";

class SectionForm extends Form {
    constructor() {
        super();
        this.sectionCreateBtn = $(".sectionCreateBtn");
        this.sectionType = $(".sectionType");
        this.closeModalBtn = $(".btnCloseModal");
        this.saveModalFormBtn = $(".btnSaveModalForm");
        this.saveAndCloseModalFormBtn = $(".btnSaveAndCloseModalForm");
        this.isActiveForm = $(".is_active").parent();
        this.typeForm = $("#type").parent();
        this.sectionCreate = $("#sectionCreate");
        this.sectionTypeForm = $("#sectionTypeForm");
        this.sectionTypes = this.sectionTypeForm.find(".sectionType");
        // this.sectionElementTypeForm = $("#sectionElementTypeForm");
        // this.sectionElementTypes = this.sectionElementTypeForm.find(
        //     ".sectionElementType"
        // );
    }

    selectType(event) {
        const target = $(event.currentTarget);
        if (
            target.data("sectiontype") &&
            target.data("parentid") &&
            target.data("parentclass")
        ) {
            window.location =
                this.sectionTypeForm.data("route") +
                "/?type=" +
                target.data("sectiontype") +
                "&parent_id=" +
                target.data("parentid") +
                "&parent_type=" +
                target.data("parentclass");
        }
    }

    // selectElementType(event) {
    //     const target = $(event.currentTarget);
    //     if (target.data("sectionelementtype") && target.data("sectionid")) {
    //         window.location =
    //             this.sectionElementTypeForm.data("route") +
    //             "/?type=" +
    //             target.data("sectionelementtype") +
    //             "&section_id=" +
    //             target.data("sectionid");
    //     }
    // }
}

export default SectionForm;
