"use strict";

import EntityListNestable from "./entity-list-nestable";

class NestableSectionElementsList extends EntityListNestable {
    constructor(listId) {
        super(listId);

        this.deleteBtns = this.entityList.find(".sectionElementDeleteBtn");
    }

    deleteRecord(e) {
        e.preventDefault();
        if (!confirm("Are you sure you want to delete this section element?")) {
            return false;
        }

        const target = $(e.currentTarget);
        $.ajax({
            url: target.data("route"),
            type: "DELETE",
            headers: { "X-CSRF-Token": $('input[name="_token"]').val() },
        })
            .done(() => {
                target.closest(".dd-item").remove();
            })
            .fail((xhr) => {
                target
                    .parent()
                    .find(".errorMessage")
                    .addClass("alert alert-danger")
                    .text(xhr.responseJSON.error);
            });
    }
}

export default NestableSectionElementsList;
