"use strict";

class EntityList {
    constructor(listId) {
        this.entityList = $(`#${listId}`);
        this.recordActiveSwitch = this.entityList.find(
            'input[name="record_active"]'
        );
        this.recordFavoriteSwitch = this.entityList.find(
            'input[name="record_favorite"]'
        );
        this.deleteRecordForm = this.entityList.find(".deleteRecord");
    }

    toggleActive(event) {
        const switchInput = $(event.target);
        const form = switchInput.parent();

        $.ajax({
            headers: {
                "X-CSRF-Token": form.find('input[name="_token"]').val(),
            },
            url: form.attr("action"),
            type: "PATCH",
            data: { is_active: switchInput.data("isactive") }
        })
            .done(() => {
                switchInput.trigger("blur");
                switchInput.data("isactive", switchInput.data("isactive") === 1 ? 0 : 1);
            });
    }

    toggleFavorite(event) {
        const switchInput = $(event.target);
        const form = switchInput.parent();

        $.ajax({
            headers: {
                "X-CSRF-Token": form.find('input[name="_token"]').val(),
            },
            url: form.attr("action"),
            type: "PATCH",
            data: { is_favorite: switchInput.data("isfavorite") }
        })
            .done(() => {
                switchInput.trigger("blur");
                switchInput.data("isfavorite", switchInput.data("isfavorite") === 1 ? 0 : 1);
            });
    }

    deleteRecord(e) {
        e.preventDefault();
        if (confirm("Are you sure you want to delete this record?")) {
            return e.target.submit();
        }

        return false;
    }
}

export default EntityList;
