"use strict";

import Form from "./form";
import Sortable from "sortablejs";

class EntityForm extends Form {
    constructor() {
        super();
        this.form = $("#recordForm form");
        this.isActiveForm = $("#is_active").parent();
        this.image = this.form.find(".image");
        this.coverImage = this.form.find(".coverImage");
        this.secondaryImage = this.form.find(".secondaryImage");
        this.imageUploadBtn = this.form.find(".imageUploadBtn");
        this.coverImgUploadBtn = this.form.find(".coverImgUploadBtn");
        this.imageDeleteBtn = this.form.find(".imageDeleteBtn");
        this.coverImgDeleteBtn = this.form.find(".coverImgDeleteBtn");
        this.secondaryImgUploadBtn = this.form.find(".secondaryImgUploadBtn");
        this.secondaryImgDeleteBtn = this.form.find(".secondaryImgDeleteBtn");
        this.galleryImgUploadBtn = this.form.find("#galleryImgUploadBtn");
        this.galleryImgDeleteBtns = this.form.find(".galleryImgDeleteBtns");
        this.inputEyeIcons = this.form.find(".inputEyeIcon");
    }

    formMenuScrollHandler() {
        $(window).on("scroll", () => {
            if ($(window).scrollTop() > 70) {
                $(".topMenu").css("top", 0);
            } else {
                $(".topMenu").css("top", "100px");
            }
        });
    }

    uploadImage(e, imageUploadBtn) {
        const filePreview = $(e.target)
            .closest(".parentImageUploadBtn")
            .prev(".filePreview");

        window.processSelectedImage = function (
            filePaths,
            tmbs,
            requestingField
        ) {
            filePreview
                .find("." + requestingField)
                .val(filePaths[0])
                .trigger("change");
            filePreview.find("img").attr("src", tmbs[0]);
        };

        imageUploadBtn.colorbox({
            href: imageUploadBtn.data("filemanagerroute"),
            width: "80%",
            height: "80%",
            fastIframe: true,
            iframe: true,
            onClosed: function () {
                if (filePreview.find("img").attr("src")) {
                    filePreview.removeClass("hidden");
                }
            },
        });
    }

    uploadCoverImg(e, coverImgUploadBtn) {
        const filePreview = $(e.target)
            .closest(".parentCoverImgUploadBtn")
            .prev(".filePreview");

        window.processSelectedCoverImg = function (
            filePaths,
            tmbs,
            requestingField
        ) {
            filePreview
                .find("." + requestingField)
                .val(filePaths[0])
                .trigger("change");
            filePreview.find("img").attr("src", tmbs[0]);
        };

        coverImgUploadBtn.colorbox({
            href: coverImgUploadBtn.data("filemanagerroute"),
            width: "80%",
            height: "80%",
            fastIframe: true,
            iframe: true,
            onClosed: function () {
                if (filePreview.find("img").attr("src")) {
                    filePreview.removeClass("hidden");
                }
            },
        });
    }

    uploadSecondaryImg(e, secondaryImgUploadBtn) {
        const filePreview = $(e.target)
            .closest(".parentSecondaryImgUploadBtn")
            .prev(".filePreview");

        window.processSelectedSecondaryImg = function (
            filePaths,
            tmbs,
            requestingField
        ) {
            filePreview
                .find("." + requestingField)
                .val(filePaths[0])
                .trigger("change");
            filePreview.find("img").attr("src", tmbs[0]);
        };

        secondaryImgUploadBtn.colorbox({
            href: secondaryImgUploadBtn.data("filemanagerroute"),
            width: "80%",
            height: "80%",
            fastIframe: true,
            iframe: true,
            onClosed: function () {
                if (filePreview.find("img").attr("src")) {
                    filePreview.removeClass("hidden");
                }
            },
        });
    }

    deleteImage(e) {
        e.preventDefault();
        const imageDeleteBtn = $(e.target).closest(".imageDeleteBtn"),
            image = imageDeleteBtn
                .closest(".parentImageUploadBtn")
                .prevAll(".image"),
            filePreview = imageDeleteBtn
                .closest(".parentImageUploadBtn")
                .prev(".filePreview");

        if (!confirm("Are you sure you want to delete this image?")) {
            return false;
        }
        $.ajax({
            headers: {
                "X-CSRF-Token": this.form.find('input[name="_token"]').val(),
            },
            url: imageDeleteBtn.data("deleteimageroute"),
            type: "PATCH",
        }).done(() => {
            image
                .find("img")
                .attr("src", image.find("img").data("default-image"));
            imageDeleteBtn.addClass("hidden");
            filePreview.find(".image").val("");
        });
    }

    deleteCoverImg(e) {
        e.preventDefault();
        const coverImgDeleteBtn = $(e.target).closest(".coverImgDeleteBtn"),
            coverImage = coverImgDeleteBtn
                .closest(".parentCoverImgUploadBtn")
                .prevAll(".coverImage"),
            filePreview = coverImgDeleteBtn
                .closest(".parentCoverImgUploadBtn")
                .prev(".filePreview");

        if (!confirm("Are you sure you want to delete this image?")) {
            return false;
        }
        $.ajax({
            headers: {
                "X-CSRF-Token": this.form.find('input[name="_token"]').val(),
            },
            url: coverImgDeleteBtn.data("deletecoverimageroute"),
            type: "PATCH",
        }).done(() => {
            coverImage
                .find("img")
                .attr("src", coverImage.find("img").data("default-image"));
            coverImgDeleteBtn.addClass("hidden");
            filePreview.find(".cover_image").val("");
        });
    }

    deleteSecondaryImg(e) {
        e.preventDefault();
        const secondaryImgDeleteBtn = $(e.target).closest(
                ".secondaryImgDeleteBtn"
            ),
            secondaryImage = secondaryImgDeleteBtn
                .closest(".parentSecondaryImgUploadBtn")
                .prevAll(".secondaryImage"),
            filePreview = secondaryImgDeleteBtn
                .closest(".parentSecondaryImgUploadBtn")
                .prev(".filePreview");

        if (!confirm("Are you sure you want to delete this image?")) {
            return false;
        }
        $.ajax({
            headers: {
                "X-CSRF-Token": this.form.find('input[name="_token"]').val(),
            },
            url: secondaryImgDeleteBtn.data("deletesecondaryimageroute"),
            type: "PATCH",
        }).done(() => {
            secondaryImage
                .find("img")
                .attr("src", secondaryImage.find("img").data("default-image"));
            secondaryImgDeleteBtn.addClass("hidden");
            filePreview.find(".secondary_image").val("");
        });
    }

    uploadGalleryImg(galleryImgUploadBtn) {
        window.processSelectedGalleryImg = function (
            filePaths,
            tmbs,
            requestingField
        ) {
            $("#" + requestingField)
                .val(filePaths)
                .trigger("change");
        };

        galleryImgUploadBtn.colorbox({
            href: galleryImgUploadBtn.data("filemanagerroute"),
            width: "80%",
            height: "80%",
            fastIframe: true,
            iframe: true,
            onClosed: () => {
                $.ajax({
                    headers: {
                        "X-CSRF-Token": this.form
                            .find('input[name="_token"]')
                            .val(),
                    },
                    url: this.galleryImgUploadBtn.data("uploadimageroute"),
                    type: "POST",
                    data: {
                        file_path: $("#gallery_image").val(),
                    },
                }).done(() => {
                    location.reload();
                });
            },
        });
    }

    deleteGalleryImg(e) {
        e.preventDefault();

        if (!confirm("Are you sure you want to delete this image?")) {
            return false;
        }

        const target = $(e.currentTarget);
        $.ajax({
            url: target.data("route"),
            type: "DELETE",
            headers: { "X-CSRF-Token": $('input[name="_token"]').val() },
        }).done(() => {
            target.closest(".galleryImgSection").remove();
        });
    }

    sortGalleryImgs(imagesGallery) {
        Sortable.create(imagesGallery, {
            store: {
                set: function () {
                    let order = {};
                    $(".galleryImgSection").each(function () {
                        order[$(this).data("id")] = $(this).index();
                    });

                    $.ajax({
                        headers: {
                            "X-CSRF-Token": $("input[name='_token'").val(),
                        },
                        url: imagesGallery.dataset.setroute,
                        type: "POST",
                        data: { order: order },
                    });
                },
            },
        });
    }

    togglePasswordVisibility(e) {
        const input = $(e.currentTarget).prev("input");
        if (input.attr("type") === "password") {
            input.attr("type", "text");
        } else {
            input.attr("type", "password");
        }
    }

    recordFormMenuPosition() {
        $(window).on("scroll", function () {
            let menu = $(".recordFormMenu");

            if ($(this).scrollTop() > 40) {
                menu.addClass("fixed-top");
            } else {
                menu.removeClass("fixed-top");
            }
        });
    }
}

export default EntityForm;
