"use strict";

// import "../../js/bootstrap";

import "@admin-template/vendor/js/helpers.js";

import "@admin-template/vendor/js/core.js";
// import "@admin-template/vendor/libs/jquery/jquery.js";
// import "@admin-template/vendor/libs/popper/popper.js";
// import "@admin-template/vendor/js/bootstrap.js";
import "@admin-template/vendor/libs/perfect-scrollbar/perfect-scrollbar.js";
import "@admin-template/vendor/js/menu.js";
import "@admin-template/vendor/libs/masonry/masonry.js";
import "@admin-template/vendor/libs/apex-charts/apexcharts.js";
import "@admin-template/js/main.js";
import "@admin-template/js/ui-popover.js";
import "@admin-template/js/dashboards-analytics.js";

import "@js-vendor/jquery.nestable.js";

import "jquery-colorbox/jquery.colorbox-min";
import "jquery-colorbox/example1/colorbox.css";

import EntityList from "./entity-list";
import EntityListNestable from "./entity-list-nestable";
import NestableSectionsList from "./nestable-sections-list";
import NestableSectionElementsList from "./nestable-section-elements-list";
import EntityForm from "./entity-form";
import Seo from "./seo";
import SectionTypeForm from "./section-form";
import Profile from "./profile";

$(() => {
    if ($("#entityList").length) {
        const entityList = new EntityList("entityList");
        entityList.recordActiveSwitch.on("change", (event) => {
            if (event.target.tagName === "INPUT") {
                entityList.toggleActive(event);
            }
        });

        entityList.deleteRecordForm.on("submit", function (e) {
            entityList.deleteRecord(e);
        });
    }

    if ($("#sectionList").length) {
        const nestableSectionsList = new NestableSectionsList("nestable");
        nestableSectionsList.entityList
            .nestable({
                maxDepth: 5,
            })
            .on("change", (event) => {
                if (event.target.tagName === "DIV") {
                    nestableSectionsList.sort();
                }
            });

        nestableSectionsList.recordActiveSwitch.on("change", (event) => {
            if (event.target.tagName === "INPUT") {
                nestableSectionsList.toggleActive(event);
            }
        });

        nestableSectionsList.deleteBtns.on("click", (e) => {
            nestableSectionsList.deleteRecord(e);
        });
    } else if ($("#sectionElementList").length) {
        const nestableSectionElementsList = new NestableSectionElementsList(
            "nestable"
        );
        nestableSectionElementsList.entityList
            .nestable({
                maxDepth: 1,
            })
            .on("change", (event) => {
                if (event.target.tagName === "DIV") {
                    nestableSectionElementsList.sort();
                }
            });

        nestableSectionElementsList.deleteBtns.on("click", (e) => {
            nestableSectionElementsList.deleteRecord(e);
        });
    } else if ($("#nestable").length) {
        const entityListNestable = new EntityListNestable("nestable");
        entityListNestable.recordActiveSwitch.on("change", (event) => {
            if (event.target.tagName === "INPUT") {
                entityListNestable.toggleActive(event);
            }
        });

        entityListNestable.recordFavoriteSwitch.on("change", (event) => {
            if (event.target.tagName === "INPUT") {
                entityListNestable.toggleFavorite(event);
            }
        });

        entityListNestable.entityList
            .nestable({
                maxDepth: 5,
            })
            .on("change", (event) => {
                if (event.target.tagName === "DIV") {
                    entityListNestable.sort();
                }
            });

        entityListNestable.deleteRecordForm.on("submit", function (e) {
            entityListNestable.deleteRecord(e);
        });
    }

    if ($("#sectionTypeForm").length) {
        const sectionTypeForm = new SectionTypeForm();

        sectionTypeForm.sectionTypes.on("click", (e) => {
            sectionTypeForm.selectType(e);
        });
    }

    // if ($("#sectionElementTypeForm").length) {
    //     const sectionElementTypeForm = new SectionTypeForm();

    //     sectionElementTypeForm.sectionElementTypes.on("click", (e) => {
    //         sectionElementTypeForm.selectElementType(e);
    //     });
    // }

    if ($("#recordForm").length) {
        const entityForm = new EntityForm();
        entityForm.formMenuScrollHandler();

        entityForm.recordFormMenuPosition();

        $(".seoPanelVisibilitySwitch").on("click", (e) => {
            const seoPanel = $(e.currentTarget).next(".seoPanel");
            if (seoPanel.hasClass("d-none")) {
                seoPanel.removeClass("d-none");
            } else {
                seoPanel.addClass("d-none");
            }
        });

        const pageSeo = new Seo();
        pageSeo.titleHandler();
        pageSeo.descriptionHandler();
        pageSeo.metaTitleHandler();
        pageSeo.metaDescriptionHandler();
        pageSeo.slugHandler();

        if (entityForm.imageUploadBtn.length) {
            entityForm.imageUploadBtn.on("click", function (e) {
                entityForm.uploadImage(e, entityForm.imageUploadBtn);
            });
        }

        if (entityForm.coverImgUploadBtn.length) {
            entityForm.coverImgUploadBtn.on("click", function (e) {
                entityForm.uploadCoverImg(e, entityForm.coverImgUploadBtn);
            });
        }

        if (entityForm.secondaryImgUploadBtn.length) {
            entityForm.secondaryImgUploadBtn.on("click", function (e) {
                entityForm.uploadSecondaryImg(e, entityForm.secondaryImgUploadBtn);
            });
        }

        entityForm.imageDeleteBtn.on("click", function (e) {
            entityForm.deleteImage(e);
        });

        entityForm.coverImgDeleteBtn.on("click", function (e) {
            entityForm.deleteCoverImg(e);
        });

        entityForm.secondaryImgDeleteBtn.on("click", function (e) {
            entityForm.deleteSecondaryImg(e);
        });

        if (entityForm.galleryImgUploadBtn.length) {
            entityForm.uploadGalleryImg(entityForm.galleryImgUploadBtn);

            entityForm.galleryImgDeleteBtns.on("click", function (e) {
                entityForm.deleteGalleryImg(e);
            });
        }

        const imagesGallery = document.getElementById("imagesGallery");
        if (imagesGallery) {
            entityForm.sortGalleryImgs(imagesGallery);
        }

        if (entityForm.inputEyeIcons.length) {
            entityForm.inputEyeIcons.on("click", function (e) {
                entityForm.togglePasswordVisibility(e);
            });
        }
    }

    const formAccountDeactivationForm = $("#formAccountDeactivation");
    if (formAccountDeactivationForm.length) {
        const profile = new Profile();
        profile.handleDeleteAccount(formAccountDeactivationForm);
    }

    $(".alert-site")
        .fadeTo(2000, 500)
        .slideUp(500, function () {
            $(".alert-site").slideUp(500);
        });

    let loader = null;
    $.ajaxSetup({
        beforeSend: function () {
            if (this.type == "GET") {
                clearTimeout(loader);
                loader = setTimeout(function () {
                    $("#loader-main-bg").show();
                }, 1000);
            } else {
                $("#loader-main-bg").show();
            }
        },
        complete: function () {
            clearTimeout(loader);
            setTimeout(function () {
                $("#loader-main-bg").hide();
            }, 500);
        },
        error: function (x, status, error) {
            $("#loader-main-bg").hide();
        },
    });
});
