import { resolve } from 'path';
import { fileURLToPath, URL } from 'node:url';
// import { splitVendorChunkPlugin } from "vite"; use vite-plugin-chunk-split instead
import inject from '@rollup/plugin-inject';
import handlebars from 'vite-plugin-handlebars';
import { pages, pagesData } from './pages';
import { parse } from 'node:path';

export default {
  root: './src',
  publicDir: '../static/',
  server: {
    host: true,
    open: './index.html',
  },
  build: {
    outDir: '../dist',
    emptyOutDir: true,
    sourcemap: true,
    rollupOptions: {
      input: { ...pages },
      output: {
        assetFileNames: (assetInfo) => {
          let extType = assetInfo.name.split('.').at(1);
          if (/png|jpe?g|svg|gif|tiff|bmp|ico/i.test(extType)) {
            extType = 'img';
          } else if (/ttf|eot|svg|woff|woff2|otf/i.test(extType)) {
            extType = 'fonts';
          }
          return `assets/${extType}/[name]-[hash][extname]`;
        },
        chunkFileNames: 'assets/js/[name]-[hash].js',
        entryFileNames: 'assets/js/[name]-[hash].js',
      },
    },
  },
  css: {
    devSourcemap: true,
    preprocessorOptions: {
      scss: {
        api: 'modern-compiler', // or "modern"
      },
    },
  },
  resolve: {
    alias: {
      // "@": resolve(__dirname, "./src/assets"),
      '@': fileURLToPath(new URL('./src/assets', import.meta.url)),
      '~': fileURLToPath(new URL('./node_modules', import.meta.url)),
    },
  },
  plugins: [
    // inject({
    //   $: 'jquery',
    //   jQuery: 'jquery',
    //   // slick: 'slick-carousel'
    // }),
    // splitVendorChunkPlugin({}),
    handlebars({
      // context(pagePath) {
      //   return pagesData[pagePath];
      // },
      context: {
        ...pagesData,
      },
      partialDirectory: resolve(__dirname, './src/partials'),
      helpers: {
        object: ({ hash }) => hash,
        array: (args) => Array.from(args).slice(0, args.length - 1),
        parseArray: (arrayAsString) => {
          var array = eval(arrayAsString);
          if (Array.isArray(array)) {
            return array;
          }
        },

        json: (value) => {
          const json = JSON.stringify(value);
          const object = eval(json);
          return JSON.parse(object);
        },


        for: (from, to, incr, block) => {
          var accum = '';
          for (var i = from; i < to; i += incr) accum += block.fn(i);
          return accum;
        },
        times: (n, block) => {
          var accum = '';
          for (var i = 0; i < n; ++i) accum += block.fn(i);
          return accum;
        },
        ifEquals: (a, b, options) => {
          if (a == b) {
            return options.fn(this);
          } else {
            return options.inverse(this);
          }
        },
        // !!! can't nest compare inside each other
        compare: (lvalue, operator = '==', rvalue, options) => {
          var operators, result;

          if (lvalue === undefined || rvalue === undefined) {
            throw new Error("Handlerbars Helper 'compare' needs 2 parameters");
          }

          if (options === undefined) {
            options = rvalue;
            rvalue = operator;
            operator = '===';
          }

          operators = {
            '==': function (l, r) {
              return l == r;
            },
            '===': function (l, r) {
              return l === r;
            },
            '!=': function (l, r) {
              return l != r;
            },
            '!==': function (l, r) {
              return l !== r;
            },
            '<': function (l, r) {
              return l < r;
            },
            '>': function (l, r) {
              return l > r;
            },
            '<=': function (l, r) {
              return l <= r;
            },
            '>=': function (l, r) {
              return l >= r;
            },
            typeof: function (l, r) {
              return typeof l == r;
            },
          };

          if (!operators[operator]) {
            throw new Error("Handlerbars Helper 'compare' doesn't know the operator " + operator);
          }

          result = operators[operator](lvalue, rvalue);

          if (result) {
            return options.fn(this);
          } else {
            return options.inverse(this);
          }
        },
      },
    }),
  ],
};
