/** @type {import('tailwindcss').Config} */
const plugin = require('tailwindcss/plugin');
export default {
  content: ['./src/**/*.{html,js}', './src/**/*.{js,ts,jsx,tsx,hbs,html}'],
  theme: {
    fontFamily: {
      primary: ['var(--font-primary)'],
    },
    borderRadius: {
      xl: 'var(--border-radius-xl)',
      lg: 'var(--border-radius-lg)',
      md: 'var(--border-radius-md)',
      sm: 'var(--border-radius-sm)',
      xs: 'var(--border-radius-xs)',
    },
    colors: {
      primary: 'var(--color-primary)',
      black: 'var(--text-color)',
      gray: 'var(--color-gray)',
      'gray-subtle': 'var(--color-gray-subtle)',
      'blue-subtle': 'var(--color-blue-subtle)',
      white: 'var(--color-white)',
      'white-2': 'var(--color-white-2)',
      'white-40': 'var(--color-white-40)',
      'white-60': 'var(--color-white-60)',
      'brand-blue': 'var(--color-brand-blue)',
      blue: 'var(--color-action)',
      action: 'var(--color-action)',
      infobox: 'var(--color-infobox)',
      paragraph: 'var(--color-paragraph)',
      heading: 'var(--color-heading)',
    },
    screens: {
      uhd: { raw: '(max-width: 3840px)' },
      qhd: { raw: '(max-width: 2560px)' },
      fhd: { raw: '(max-width: 1920px)' },
      desktop: { raw: '(max-width: 1568px)' },
      '2xl': { raw: '(max-width: 1536px)' },
      xl: { raw: '(max-width: 1366px)' },
      'w-1280': { raw: '(max-width: 1280px)' },
      lg: { raw: '(max-width: 1024px)' },
      md: { raw: '(max-width: 768px)' },
      sm: { raw: '(max-width: 640px)' },
      xs: { raw: '(max-width: 480px)' },
      'w-380': { raw: '(max-width: 380px)' },

      'uhd-min': { raw: '(min-width: 3841px)' },
      'qhd-min': { raw: '(min-width: 2561px)' },
      'fhd-min': { raw: '(min-width: 1921px)' },
      'desktop-min': { raw: '(min-width: 1569px)' },
      '2xl-min': { raw: '(min-width: 1537px)' },
      'xl-min': { raw: '(min-width: 1367px)' },
      'lg-min': { raw: '(min-width: 1025px)' },
      'md-min': { raw: '(min-width: 769px)' },
      'sm-min': { raw: '(min-width: 641px)' },
      'xs-min': { raw: '(min-width: 481px)' },
      'v-800': { raw: '(max-height: 800px) and max-width: 1024px' },
    },
    extend: {
      containers: {
        '5xl': '3840px',
        '4xl': '2560px',
        '3xl': '1920px',
        '2xl': '1536px',
        xl: '1366px',
        lg: '1024px',
        md: '768px',
        sm: '640px',
        xs: '480px',
      },
      aspectRatio: {
        'image-sm': 'var(--aspect-ratio-image-sm)',
        'image-md': 'var(--aspect-ratio-image-md)',
        'image-lg': 'var(--aspect-ratio-image-lg)',
      },
      spacing: {
        1: '1rem',
        2: '2rem',
        3: '3rem',
        4: '4rem',
        5: '5rem',
        6: '6rem',
        7: '7rem',
        8: '8rem',
        9: '9rem',
        10: '10rem',
        11: '11rem',
        12: '12rem',
        13: '13rem',
        14: '14rem',
        15: '15rem',
        16: '16rem',
        17: '17rem',
        18: '18rem',
        19: '19rem',
        20: '20rem',
        30: '30rem',
        40: '40rem',
        50: '50rem',
        60: '60rem',
        70: '70rem',
        80: '80rem',
        90: '90rem',
      },
    },
  },
  plugins: [
    require('@tailwindcss/container-queries'),
    plugin(function ({ addVariant }) {
      addVariant('children', '&>*');
    }),
  ],
};
