import * as _ from "lodash-es";
import { CONSTANTS } from "../helpers";
import Core from "./Core";

export default class ShowMore {
    constructor(options) {
        this.options = options;
        this.$section = options.section;
        this.$container = this.$section.find(`.${options.expandableSelector}`);
        this.$showMore = this.$section.find(`.${options.showMoreSelector}`);
        this.$textExpand = this.$showMore.find(".expand");
        this.$textCollapse = this.$showMore.find(".collapse");
        this.restrictedHeights = {
            xs: this.$container.data("xs"),
            sm: this.$container.data("sm"),
            md: this.$container.data("md"),
            lg: this.$container.data("lg"),
            xl: this.$container.data("xl"),
            desktop: this.$container.data("desktop"),
        };
        this.restrictedHeight = 0;
        this.fullHeight = 0;
        this.query = "";
        (this.gradientTypeClass = `u-bottom-gradient-type-${this.$container.data(
            "gradient-type"
        )}`),
            (this.speedShowElements = options.speedShowElements);
        this.speedHideShowMore = options.speedHideShowMore;
        this.active = false;
    }
    init() {
        const self = this;
        self.clear(); // reset state (classes, height)
        if (self.$showMore.length === 0) return; // container has already been open
        self.setState();
        self.$showMore.on("click", function (e) {
            e.stopPropagation();
            self.$textExpand.toggle();
            self.$textCollapse.toggle();
            Core.isDev
                ? console.log(
                      "🚀 ~ file: ShowMore.js:52 ~ ShowMore ~ self.active:",
                      self.active
                  )
                : "";
            if (self.active) {
                self.$container.animate(
                    {
                        height: `${self.fullHeight}px`,
                    },
                    (self.fullHeight / self.restrictedHeight) *
                        CONSTANTS.TR_SPEED.normal,
                    function () {}
                );
                self.$container.removeClass(self.gradientTypeClass);
                self.active = false;
            } else {
                self.$container.animate(
                    {
                        height: `${self.restrictedHeight}px`,
                    },
                    (self.fullHeight / self.restrictedHeight) *
                        CONSTANTS.TR_SPEED.normal,
                    function () {}
                );
                self.$container.addClass(self.gradientTypeClass);
                self.active = true;
            }
        });
        let heightTemp = $(window).height();
        $(window).resize(
            _.throttle((num) => {
                const heightNew = $(window).height();
                if (heightNew !== heightTemp) {
                    heightTemp = heightNew;
                    return;
                }
                self.setState();
            }, 250)
        );
    }
    setState() {
        const self = this;
        self.query = Core.getCurrMediaQuery();
        self.$container.css("height", `auto`);
        self.restrictedHeight = self.restrictedHeights[self.query];
        self.fullHeight = self.$container.outerHeight();
        if (!self.restrictedHeight) {
            return;
        }
        if (self.fullHeight > self.restrictedHeight) {
            self.active = true;
            self.showShowMore();
            self.$container.addClass(self.gradientTypeClass);
            self.$container.css("height", `${self.restrictedHeight}px`);
            self.$textExpand.show();
            self.$textCollapse.hide();
        } else {
            self.active = false;
            self.hideShowMore();
            return;
        }
        return this;
    }
    clear() {
        const self = this;
        self.$container.removeClass(self.gradientTypeClass);
        self.$container.css("height", "unset");
        self.$showMore.off();
    }
    hideShowMore() {
        Core.isDev ? console.log("hideShowMore: ") : "";
        const self = this;
        self.$showMore.hide(0);
    }

    showShowMore() {
        const self = this;
        self.$showMore.show();
    }
}
