import { CONSTANTS as c, functions as f } from '../helpers';
import Core from './Core';
import InputField from './InputField';
import { controllers } from '../controllers';
import { debounce, throttle } from 'lodash-es';

const isDev = Core.isDev;

export default class Form {
  constructor(options) {
    this.$root = options.root;
    this.$form = this.$root;
    this.$inputFields = this.$root.find('textarea, input');
    this.$selectFields = this.$root.find('select');
    this.$passwordFields = this.$root.find('input[type="password"]');
    this.$datePickerFields = this.$root.find("input[type='date']");
    this.$submitBtn = this.$root.find('button[type="submit"]');
    this.$submitBtnText = this.$submitBtn.find('span');
    this.$checkAllBtn = $('.u-special-wrapper .btn');
    this.$checkAllInputs = $('.u-special-wrapper input[type="checkbox"');
    this.$steps = this.$root.find('.step');
    this.stepList = this.$steps.toArray();
    this.stepCount = this.$steps.length;
    this.formData = {};
    this.inputList = [];
    this.selectList = [];
    this.dateTimeList = [];
    this.allFieldsList = [];
    this.hasSteps = options.steps;
    this.currStep = 0;
  }
  init() {
    const self = this;

    self.setPasswordState();

    self.$selectFields.toArray().forEach((f) => {
      const field = $(f);
      field.on('change', function (e) {
        field.addClass('active');
      });
      field.on('click', function (e) {
        field.toggleClass('select-opened');
      });
    });
    $('html').on('click', function (e) {
      if (!$(e.target).hasClass('select-opened')) {
        $('.select-opened').removeClass('select-opened');
      }
    });

    self.$inputFields.filter(':not(:disabled)').map(function (field) {
      const f = new InputField($(this)).init();
      self.inputList.push(f);
    });
    self.$submitBtn.on('click submit', function (e) {
      // e.preventDefault();
      // self.prepareData();
    });
    // $(document).on('click', '.edit-file-input-text', function (e) {
    //   e.stopPropagation();
    //   if ($('input.edit').length) {
    //     self.removeEditMode();
    //   }
    //   const $input = $(this).closest('.file').find('input');
    //   // if ($(this).closest('.file').find('input.edit').length) return;
    //   // $('input.edit').attr('readonly', true);
    //   // $('input.edit').removeClass('edit');
    //   // $('.btn.confirm-file-input-text').closest('form').addClass('hidden');
    //   // $('.btn.edit-file-input-text').closest('form').removeClass('hidden');
    //   const $confirmBtn = $(this).closest('.file').find('.btn.confirm-file-input-text');
    //   $confirmBtn.closest('form').removeClass('hidden');
    //   $(this).addClass('hidden');
    //   $input.attr('readonly', false);
    //   $input.addClass('edit');
    //   $input.trigger('focus');
    // });
    // $(document).on('click', function (e) {
    //   if ($(e.target).is('input.edit')) return;
    //   self.removeEditMode();
    // });
    return self;
  }
  removeEditMode() {
    const $input = $('input.edit');
    if (!$input.length) return;
    const $file = $input.closest('.file');
    const $confirmBtn = $file.find('.btn.confirm-file-input-text').closest('form');
    const $editBtn = $file.find('.btn.edit-file-input-text');
    $confirmBtn.addClass('hidden');
    $editBtn.removeClass('hidden');
    $input.removeClass('edit');
    $('.file-input-text').attr('readonly', true);
  }
  setPasswordState() {
    const self = this;
    self.$passwordFields.toArray().forEach((input) => {
      const inputWrapper = input.parentElement;
      const icon = inputWrapper.querySelector('i');
      icon.addEventListener('click', function (e) {
        const type = input.getAttribute('type') === 'password' ? 'text' : 'password';
        input.setAttribute('type', type);
        if (type === 'text') {
          icon.className = 'icon-eye-closed';
        } else {
          icon.className = 'icon-eye-opened';
        }
      });
    });

    return self;
  }

  prepareData() {
    const self = this;
    self.formData = self.$form.serializeArray();
    isDev ? console.log(self.formData) : '';
    return self;
  }

  successHandler(response) {
    const self = this;
    console.log('🚀 ~ file: Form.js:130 ~ Form ~ successHandler ~ $(self):', $(self));
    if (self.$root.is('.s-form-1')) {
      console.log('🚀 ~ file: Form.js:130 ~ Form ~ successHandler ~ s-form-1:');
      self.renderSuccessPopup(response.message);
      f.renderPatients(response.data, 'form');
    } else {
      console.log('regular form');
    }
    self.reset();
    return self;
  }
  renderSuccessPopup(message) {
    if (!message) return;
    const self = this;
    const options = {
      title: message.title ? message.title : '',
      content: message.content ? message.content : '',
    };
    setTimeout(() => {
      $.magnificPopup.close();
      const $successMessage = controllers.RendererController.init('form-success', options);
      controllers.MagnificPopupController.init('form-success', $successMessage);
    }, 0);
    return self;
  }
  errorHandler(jqXHR, textStatus, errorThrown, form) {
    const self = this;
    const formId = $(self).attr('id');
    isDev ? console.log(jqXHR, textStatus, errorThrown) : '';
    if (jqXHR.status == 422) {
      if (!jqXHR?.responseJSON) return;
      if (jqXHR?.responseJSON?.errors) {
        // if (!jqXHR?.responseJSON?.data?.results) return;
        const response = jqXHR?.responseJSON?.errors; // ?.data?.results;
        isDev ? console.log('response: ', response) : '';
        const step = self.stepList[self.currStep];
        let errInCurrStep = false;
        for (const fieldName in response) {
          if (response.hasOwnProperty(fieldName)) {
            const msg = response[fieldName];

            if (fieldName == 'g-recaptcha-response') {
              self.renderErrorReCAPTCHA('#recaptcha-error', msg);
            } else {
              self.renderError(fieldName, msg, formId);
            }
            if (
              (fieldName == 'g-recaptcha-response' &&
                $(step).find('[name="g-recaptcha-response"]').length) ||
              $(step).find(`[name^=${fieldName}`).length
            ) {
              errInCurrStep = true;
            }
          }
        }
        if (!errInCurrStep) {
          self.changeStep(+1);
        }
      }
      if (jqXHR?.responseJSON?.message) {
        let message = jqXHR?.responseJSON?.message;
        if (!message) message = Core.translations.server_error_message;
        if (!message) message = 'Възникна грешка';
        toastr.error(message);
      }
    } else {
      let message = jqXHR?.responseJSON?.message;
      if (!message) message = Core.translations.server_error_message;
      if (!message) message = 'Възникна грешка';
      toastr.error(message);
    }

    return self;
  }
  renderErrorReCAPTCHA(element, msgs) {
    const self = this;
    const $field = $(document).find(element);
    const $fieldFromGroup = $field.closest('.form-group-captcha');
    const $fieldError = $('<span class="error-msg" style="text-align: center;"></span>');
    $fieldFromGroup.append($fieldError);
    $fieldFromGroup.addClass('error');
    msgs.forEach((errorMsg) => {
      $fieldError.append(errorMsg);
    });
    return self;
  }
  renderError(fieldName, msgs, formId) {
    const self = this;
    const $field = self.$form.find(`[name ^= ${fieldName}]`).first();
    const $fieldFromGroup = $field.closest('.form-group');
    const $fieldError = $('<span class="error-msg"></span>');
    $fieldFromGroup.append($fieldError);
    $fieldFromGroup.addClass('error');
    msgs.forEach((errorMsg) => {
      $fieldError.append(errorMsg);
    });
    return self;
  }

  clearErrors() {
    const self = this;
    const $fieldsFormGroup = self.$form.find('.form-group');
    const $fieldError = $fieldsFormGroup.find('.error-msg');
    $fieldsFormGroup.removeClass('error');
    $fieldError.remove();
    return self;
  }
  test() {
    const self = this;
    self.fill(true);
    self.allFieldsList.forEach((field) => {
      field.check();
    });
    return self;
  }
  fill(val = true) {
    const self = this;
    self.set(true);
    return self;
  }
  reset() {
    const self = this;
    self.set(false);
    self.clearErrors();
    self.allFieldsList.forEach((f) => {
      f.check();
      if (f.type === 'select') {
        f.reset();
      }
    });
    self.setStepState();
    self.$submitBtn.attr('disabled', false);
    return self;
  }
  set(fill) {
    const self = this;
    self.$inputFields.toArray().forEach((f) => {
      if ($(f).is('input:checkbox')) {
        $(f).prop('checked', fill);
      } else if ($(f).is('input:radio')) {
      } else if ($(f).is('input:hidden')) {
      } else {
        if (!$(f).is('input[name="_token"]') && !$(f).is('input[name="_token"]')) {
          $(f).val(fill ? 'test' : '');
        }
      }
    });
    self.$selectFields.toArray().forEach((f) => {
      fill ? ($(f)[0].selectedIndex = 0) : ($(f)[0].selectedIndex = 1);
    });
  }
  redirect(url) {
    const self = this;
    window.location.replace(url);
    return self;
  }
  changeStep(increment) {
    const self = this;
    if (self.currStep + increment < 0 && self.currStep + increment >= self.stepCount) {
      return self;
    }
    self.currStep += increment;
    self.setStepState();
    if ($('.mfp-container')[0]) $('.mfp-container')[0].scrollIntoView();

    if (self.$root.is('.s-popup-registration')) {
      if (self.currStep !== 0) {
        self.$root.find('.only-step-1, .heading-wrapper').hide();
      } else {
        self.$root.find('.only-step-1, .heading-wrapper').show(0);
      }
    }
    return self;
  }
  setStepState() {
    const self = this;
    for (let index = 0; index < self.stepCount; index++) {
      const step = self.stepList[index];
      if (index === self.currStep) {
        $(step).removeClass('hidden next prev');
      } else if (index < self.currStep) {
        $(step).addClass('hidden prev').removeClass('next');
      } else {
        $(step).addClass('hidden next').removeClass('prev');
      }
    }
    return self;
  }
}
