import * as CONSTANTS from '../helpers/constants';
import { throttle } from 'lodash-es';

export default class Accordion {
  constructor(options) {
    this.$el = options.el;
    this.$section = options.section;
    this.itemSelector = options.itemSelector;
    this.hiddenSelector = options.hiddenSelector;
    this.activeSelector = options.activeSelector;
    this.$items = this.$section.find(this.itemSelector);
    this.$clickAreas = this.$items.find('.tab, .icon-chevron-down');
    this.$hiddenEls = this.$items.find(this.hiddenSelector);
  }
  init() {
    const self = this;
    const throttled = throttle(toggleAccordionState, CONSTANTS.TR_SPEED.normal, { trailing: false });
    self.$clickAreas.on('click', throttled);
    function toggleAccordionState(event) {
      const $item = $(this).closest('.item');
      if ($item.hasClass(self.activeSelector)) {
        $item.removeClass(self.activeSelector);
        if (CONSTANTS.MQ_IS.md) {
          $item.find(self.hiddenSelector).hide(0);
        } else {
          $item.find(self.hiddenSelector).slideUp(CONSTANTS.TR_SPEED.normal);
        }
      } else {
        // self.$items.removeClass(self.activeSelector);
        $item.addClass(self.activeSelector);
        if (CONSTANTS.MQ_IS.md) {
        //   self.$items.find(self.hiddenSelector).hide(0);
          $item.find(self.hiddenSelector).show(0);
        } else {
        //   self.$items.find(self.hiddenSelector).slideUp(CONSTANTS.TR_SPEED.normal);
          $item.find(self.hiddenSelector).slideDown(CONSTANTS.TR_SPEED.normal);
        }
      }
    }
    // $(document).click(function (e) {
    //   if (!self.$items.is(e.target) && self.$items.has(e.target).length === 0) {
    //     self.$items.removeClass(self.activeSelector);
    //     self.$hiddenEls.slideUp(CONSTANTS.TR_SPEED.normal);
    //   }
    // });
    return self;
  }
}
