import { utilities } from '../utilities';
import { CONSTANTS as c, functions as f } from '../helpers';
import { throttle } from 'lodash-es';
import Core from '../utilities/Core';

// core version + navigation, pagination modules:
import Swiper from 'swiper';
import { Pagination, EffectFade } from 'swiper/modules';
// import Swiper styles
import 'swiper/css';
// import 'swiper/css/navigation';
import 'swiper/css/pagination';
import 'swiper/css/effect-fade';

class SwiperController {
  constructor() {
    this.sliders = [];
    this.windowSizeIsMd = true;
  }
  init() {
    const self = this;
    self.sliders = [];
    const options = {};
    self.windowSizeIsMd = c.MQ_IS.sm;
    $('[data-hero-slider]')
      .toArray()
      .forEach((section) => {
        const $root = $(section);
        const $swiper = $root.find(`.swiper`);
        const $slides = $swiper.find(`.swiper-slide`);
        // const $prev = $root.find(`.swiper-prev`);
        // const $next = $root.find(`.swiper-next`);
        if ($swiper.length) {
          const swiper = new Swiper($swiper[0], {
            // modules: [Navigation, Pagination, EffectFade],
            modules: [Pagination, EffectFade],
            slidesPerView: 1,
            effect: 'fade',
            // fadeEffect: {
            //   crossFade: true,
            // },
            pagination: {
              el: '.swiper-pagination-bullets-custom',
              clickable: true,
            },
            // navigation: {
            //   nextEl: $next[0],
            //   prevEl: $prev[0],
            // },
            breakpoints: {
              320: {
                autoHeight: true,
                speed: 0,
                loop: true,
                autoplay: false,
                pagination: {
                  dynamicBullets: $slides.length > 6,
                },
              },
              1024: {
                speed: 400,
                loop: true,
                autoplay: {
                  delay: 1000,
                  disableOnInteraction: false,
                },
                pagination: {
                  dynamicBullets: $slides.length > 6,
                },
              },
            },
          });
          // swiper.slideTo(0);

          self.sliders = [...self.sliders, swiper];
        }
      });
    self.onResize();
  }
  onResize() {
    const self = this;
    $(window).on(
      'resize',
      throttle(function () {
        if (!self.windowSizeIsMd && c.MQ_IS.sm) {
          setTimeout(() => {
            self.kill();
            self.init();
            Core.isDev ?? console.log('swiper reinit');
          }, 110);
        }
        self.windowSizeIsMd = c.MQ_IS.sm;
      }, 100)
    );
    return self;
  }
  kill() {
    const self = this;
    if (self.sliders) {
      self.sliders.forEach((slider) => slider.destroy());
    }
    return self;
  }
}
export const controller = new SwiperController();
