import { utilities } from '../utilities';
import { CONSTANTS } from '../helpers';

class MapController {
  constructor() {}
  init() {
    const self = this;

    if ($('[data-map]').length > 0) {
      const key = $('[data-map]').data('api-key');
      if (!key) return;
      $.getScript(
        `https://maps.googleapis.com/maps/api/js?key=${key}`,
        async function () {
          const { AdvancedMarkerElement } = await google.maps.importLibrary('marker');
          $.each($('[data-map]'), function (index, el) {
            const $mapEl = $(el);
            let map;
            const lat = $mapEl.data('lat');
            const lng = $mapEl.data('lon');
            const zoom = $mapEl.data('zoom');
            const mapid = $mapEl.data('mapid');
            const content = $mapEl.data('content');
            let options = {
              zoom: zoom ? zoom : 14,
              mapId: mapid,
              scaleControl: true,
              panControl: true,
              zoomControl: true,
              fullscreenControl: false,
              scrollwheel: false,
              mapTypeControl: false,
              streetViewControl: false,
              disableDefaultUI: false,
            };
            const position = { lat, lng };
            options = {
              ...options,
              center: position,
            };
            map = new google.maps.Map(el, options);
            // map.setOptions({});
            const marker = new AdvancedMarkerElement({
              position,
              map,
            });
            map.infoWindow = new google.maps.InfoWindow({
              content
            });
            google.maps.event.addListener(marker, 'click', function () {
              map.infoWindow.open(map, marker);
          });
          });
        }
      );
    }
    return self;
  }
}
export const controller = new MapController();
