import { fileURLToPath, URL } from 'node:url';

const pagesObj = [
  { name: 'index', data: {} },
  { name: 'style-guide', data: {} },
  { name: '1.home', data: {} },
  { name: '2.product-1', data: {} },
  { name: '3.product-2', data: {} },
  { name: '4.1.product-list', data: {} },
  { name: '4.2.project-list', data: {} },
  { name: '5.project', data: {} },
  { name: '6.about-us', data: {} },
  { name: '7.who-are-we', data: {} },
  { name: '8.news', data: {} },
  { name: '9.news-inner', data: {} },
  { name: '10.about-us-partners', data: {} },
  { name: '11.about-us-clients', data: {} },
  { name: '12.about-us-carriers', data: {} },
  { name: '13.about-us-contact-us', data: {} },
  { name: '14.about-us-events', data: {} },
  { name: '15.about-us-feedback', data: {} },
  { name: '16.about-us-policy', data: {} },
  { name: '17.about-us-quality', data: {} },
  { name: '18.solutions', data: {} },
  { name: '19.search', data: {} },
].map((obj) => ({
  name: obj.name,
  path: `./src/${obj.name}.html`,
  pathResolved: fileURLToPath(new URL(`./src/${obj.name}.html`, import.meta.url)),
  data: { ...obj.data },
}));

export const pages = pagesObj.reduce(
  (obj, item) => Object.assign(obj, { [item.name]: item.pathResolved }),
  {}
);
// export const pagesData = pagesObj.reduce(
//   (obj, item) => Object.assign(obj, { [item.path]: { ...item.data } }),
//   {}
// );
export const pagesData = {
  solutions: [
    {
      icon: '/images/icon-solution-1.svg',
      name: 'Дигитална трансформация',
    },
    {
      icon: '/images/icon-solution-2.svg',
      name: 'Мрежови решения',
    },
    {
      icon: '/images/icon-solution-3.svg',
      name: 'Центрове за данни',
    },
    {
      icon: '/images/icon-solution-4.svg',
      name: 'ИТ Инфраструктура',
    },
    {
      icon: '/images/icon-solution-5.svg',
      name: 'Киберсигурност',
    },
    {
      icon: '/images/icon-solution-6.svg',
      name: 'Техническо обслужване',
    },
    {
      icon: '/images/icon-solution-7.svg',
      name: 'Консултантски дейности',
    },
  ],
  solutionsDigitalTransformation: [
    {
      icon: '/images/icon-solution-1.svg',
      name: 'Дигитална трансформация',
      isActive: true,
    },
    {
      icon: '/images/icon-solution-2.svg',
      name: 'Мрежови решения',
    },
    {
      icon: '/images/icon-solution-3.svg',
      name: 'Центрове за данни',
    },
    {
      icon: '/images/icon-solution-4.svg',
      name: 'ИТ Инфраструктура',
    },
    {
      icon: '/images/icon-solution-5.svg',
      name: 'Киберсигурност',
    },
    {
      icon: '/images/icon-solution-6.svg',
      name: 'Техническо обслужване',
    },
    {
      icon: '/images/icon-solution-7.svg',
      name: 'Консултантски дейности',
    },
  ],
  industries: [
    {
      icon: '/images/icon-industry-1.png',
      name: 'Финанси',
    },
    {
      icon: '/images/icon-industry-2.png',
      name: 'Публичен сектор ',
    },
    {
      icon: '/images/icon-industry-3.png',
      name: 'Търговия',
    },
    {
      icon: '/images/icon-industry-4.png',
      name: 'Образование',
    },
    {
      icon: '/images/icon-industry-5.png',
      name: 'Енергетика и комунални услуги ',
    },
    {
      icon: '/images/icon-industry-6.png',
      name: 'Здравеопазване',
    },
    {
      icon: '/images/icon-industry-7.png',
      name: 'Производство',
    },
  ],
  partners: [
    {
      image: '/images/partner-1.png',
    },
    {
      image: '/images/partner-2.png',
    },
    {
      image: '/images/partner-3.png',
    },
    {
      image: '/images/partner-4.png',
    },
    {
      image: '/images/partner-5.png',
    },
    {
      image: '/images/partner-6.png',
    },
    {
      image: '/images/partner-7.png',
    },
    {
      image: '/images/partner-8.png',
    },
    {
      image: '/images/partner-9.png',
    },
    {
      image: '/images/partner-10.png',
    },
    {
      image: '/images/partner-11.png',
    },
    {
      image: '/images/partner-12.png',
    },
    {
      image: '/images/partner-13.png',
    },
    {
      image: '/images/partner-14.png',
    },
    {
      image: '/images/partner-15.png',
    },
    {
      image: '/images/partner-16.png',
    },
    {
      image: '/images/partner-17.png',
    },
    {
      image: '/images/partner-18.png',
    },
    {
      image: '/images/partner-19.png',
    },
  ],
  counter: [
    { number: '1500', name: 'РЕАЛИЗИРАНИ ПРОЕКТИ' },
    { number: '30', name: 'ВОДЕЩ СИСТЕМЕН ИНТЕГРАТОР' },
    { number: '500', name: 'ДОВОЛНИ КЛИЕНТИ' },
    { number: '50', name: 'ТЕХНОЛОГИЧНИ ПАРТНЬОРИ' },
  ],
  heroImages: [
    {
      image: '/images/img-hero-1.jpg',
    },
    {
      image: '/images/img-hero-2.jpg',
    },
    {
      image: '/images/img-hero-3.jpg',
    },
    {
      image: '/images/img-hero-4.jpg',
    },
    {
      image: '/images/img-hero-5.jpg',
    },
    {
      image: '/images/img-hero-6.jpg',
    },
    {
      image: '/images/img-hero-7.jpg',
    },
    {
      image: '/images/img-hero-8.jpg',
    },
  ],
  sliders: [
    {
      image: '/images/img-slider-1.jpg',
      title: 'ВИСОКО НИВО НА КИБЕРСИГУРНОСТ NIS-0 <br> Мисията възможна!',
      content:
        'Европейската директива за мрежова и информационна сигурност NIS2 влeзe в сила на 17 октомври 2024г. Парафлоу ще ви консултира да приведете вашата организация в съответствие с Директивата и да постигнете високо ниво на киберсигурност и оперативна устойчивост.',
    },
    {
      image: '/images/img-slider-2.jpg',
      title: 'ВИСОКО НИВО НА КИБЕРСИГУРНОСТ NIS-1 <br> Мисията възможна!',
      content: 'Европейската директива за мрежов',
    },
    {
      image: '/images/img-slider-1.jpg',
      title: 'ВИСОКО НИВО НА КИБЕРСИГУРНОСТ NIS-2 <br> Мисията възможна!',
      content:
        'вропейската директива за мрежова и информационна сигурност NIS2 влeзe в сила на 17 октомври 2024г. Парафлоу ще ви консултира да приведете вашата организация в',
    },
    {
      image: '/images/img-slider-2.jpg',
      title: 'ВИСОКО НИВО НА КИБЕРСИГУРНОСТ NIS-3 <br> Мисията възможна!',
      content:
        'Европейската директива за мрежова и информационна сигурност NIS2 влeзe в сила на 17 октомври 2024г. Парафлоу ще ви консултира да приведете вашата организация в съответствие с Директивата и да постигнете високо ниво на киберсигурност и оперативна устойчивост.',
    },
    {
      image: '/images/img-slider-1.jpg',
      title: 'ВИСОКО НИВО НА КИБЕРСИГУРНОСТ NIS-4 <br> Мисията възможна!',
      content: 'Европейската директива за мрежов',
    },
    {
      image: '/images/img-slider-2.jpg',
      title: 'ВИСОКО НИВО НА КИБЕРСИГУРНОСТ NIS-5 <br> Мисията възможна!',
      content:
        'вропейската директива за мрежова и информационна сигурност NIS2 влeзe в сила на 17 октомври 2024г. Парафлоу ще ви консултира да приведете вашата организация в',
    },
  ],

  businessCard: [
    {
      title: 'Организация',
      description: 'ДКУЧПППЗВАИ ПРОФОН',
    },
    {
      title: 'Индустрия',
      description: 'Публични услуги (култура и изкуство; авторски права)',
    },
    {
      title: 'Решение',
      description:
        'Системи за бизнес анализи, Системи за съвместна работа и организация на работни процеси |',
    },
    {
      title: 'Продукти',
      description: 'Microsoft 365, PowerBI, EASY365',
    },
    {
      title: 'Локация',
      description: 'България',
    },
    {
      title: 'Website',
      description: 'https://www.prophon.org/',
    },
  ],
  testimonialsHome: [
    {
      content:
        '„Миграцията на Фондация "Америка за България" към облачна инфраструктура, осъществено от висококвалифицирания екип на Парафлоу, демонстрира силата на модерните облачни технологии за трансформиране на ИТ инфраструктурата. Внедряването на модерните решения за сигурност и управление добави още едно ниво на защита и контрол, което е от съществено значение за сигурността и ефективността на организацията. Сега фондацията разполага с мощна, сигурна и адаптивна ИТ среда, която ѝ позволява да продължи своята дейност и мисия.“',
      author: 'Крум Карадаков',
      workplace: 'Фондация "Америка за България"',
    },
    {
      content:
        '„Благодарение на извършените модернизации са налице резултати като повишена отчетност и проследимост на ресурсите, по-добра структурираност на информацията и предвидимост на финансовите показатели. Внедрените нови системи са едновременно гъвкави и прецизни, като дават възможност за вземане на бързи решения в дружеството въз основа на подробните анализи.“',
      author: 'Димитър Костадинов',
      workplace: 'ДКУЧПППЗВАИ ПРОФОН',
    },
    {
      content:
        '“Парафлоу изгради за нас висококачествена система за управление на съдебни дела. Това отбелязва началото на нов етап за съдебната система, в който чрез информационни технологии служителите и гражданите получават лесен достъп до съдилищата и незабавна информация относно статуса на делата и предстоящите процесуални стъпки. Заедно с нашия ИТ партньор създадохме изключително ефективна и надеждна система за управление на съдебни производства.”',
      author: 'Dunstain Fipaumutima MWAUNGULU',
      workplace: 'Върховен съд на Малави',
    },
  ],
  testimonialProject: {
    content:
      'Хюлет-Пакард и Парафлоу ни дадоха възможност Университетът да предоставя мрежова свързаност за иновативно образование на световно ниво, а студентите да имат достъп до информация и учебно съдържание по всяко време и от всяка точка.',
    author: 'Кевин Асперген',
    position: 'президент на АУБ, CIO България',
  },
  testimonialsClients: [
    {
      content:
        '„Миграцията на Фондация "Америка за България" към облачна инфраструктура, осъществено от висококвалифицирания екип на Парафлоу, демонстрира силата на модерните облачни технологии за трансформиране на ИТ инфраструктурата. Внедряването на модерните решения за сигурност и управление добави още едно ниво на защита и контрол, което е от съществено значение за сигурността и ефективността на организацията. Сега фондацията разполага с мощна, сигурна и адаптивна ИТ среда, която ѝ позволява да продължи своята дейност и мисия.“',
      author: 'Крум Карадаков',
      workplace: 'Фондация "Америка за България"',
    },
    {
      content:
        '„Благодарение на извършените модернизации са налице резултати като повишена отчетност и проследимост на ресурсите, по-добра структурираност на информацията и предвидимост на финансовите показатели. Внедрените нови системи са едновременно гъвкави и прецизни, като дават възможност за вземане на бързи решения в дружеството въз основа на подробните анализи.“',
      author: 'Димитър Костадинов',
      workplace: 'ДКУЧПППЗВАИ ПРОФОН',
    },
    {
      content:
        '“Парафлоу изгради за нас висококачествена система за управление на съдебни дела. Това отбелязва началото на нов етап за съдебната система, в който чрез информационни технологии служителите и гражданите получават лесен достъп до съдилищата и незабавна информация относно статуса на делата и предстоящите процесуални стъпки. Заедно с нашия ИТ партньор създадохме изключително ефективна и надеждна система за управление на съдебни производства.”',
      author: 'Dunstain Fipaumutima MWAUNGULU',
      workplace: 'Върховен съд на Малави',
    },
    {
      content:
        '„„Хюлет-Пакард и Парафлоу ни дадоха възможност Университетът да предоставя мрежова свързаност за иновативно образование на световно ниво, а студентите да имат достъп до информация и учебно съдържание по всяко време и от всяка точка.“',
      author: 'Кевин Асперген',
      workplace: 'президент на АУБ, CIO България',
    },
    {
      content:
        'Извършена е интеграция на Център за обслужване на клиенти на Софарма Трейдинг АД, посредством интеграционната платформа на Парафлоу с ERP софтуера и CRM софтуера, като по този начин Call center автоматично разпознава клиентите при входящо обаждане. На база разпознат клиент, обаждането се насочва към група агенти, обслужващи дадения регион. При приемане на обаждането към оператора се подава информация за името на клиента, клиентския номер, кредитния лимит към момента, отворени тикети в Help Desk, приоритет на клиента, ценови нива, процент',
      author: 'Кевин Асперген',
      workplace: 'президент на АУБ, CIO България',
    },
    {
      content:
        'В следствие на мащабния проект за частен облак на банката 90% от инфраструктурата на УниКредит Булбанк е виртуализирана, повишена е ефективността при възстановяване от технически проблеми и е оптимизирано използването на ресурси. Екипът на Парафлоу участва в три от системите за облака - дизайн, доставки и внедряване на мрежовата част (Cisco), доставка и внедряване на сървърната част на облака (HP), внедряване на софтуерната част (Microsoft Hyper-V) и миграции на съществуващи приложения. „След успешната реализация на поредица от инфраструктурни проекти, вече разполагаме с ИТ среда, осигуряваща висока достъпност и възстановяване при бедствия“.',
      author: 'Кевин Асперген',
      workplace: 'президент на АУБ, CIO България',
    },
  ],
  management: [
    {
      image: '',
      name: 'Жана Доева',
      position: 'Вице президент Решения',
      link: '#',
    },
    {
      image: '/images/img-1-1.jpg',
      name: 'Жана-Свилена Доева Насалевска',
      position: 'Вице президент Решения',
      link: '#',
    },
    {
      image: '',
      name: 'Жана Доева',
      position: 'Вице президент Решения',
      link: '#',
    },
    {
      image: '',
      name: 'Жана Доева',
      position: 'Вице президент Решения',
      link: '#',
    },
    {
      image: '',
      name: 'Жана Доева',
      position: 'Вице президент Решения',
      link: '#',
    },
    {
      image: '',
      name: 'Жана Доева',
      position: 'Вице президент Решения',
      link: '#',
    },
  ],
  clients: [
    '/images/partner-1.png',
    '/images/partner-2.png',
    '/images/partner-3.png',
    '/images/partner-4.png',
    '/images/partner-5.png',
    '/images/partner-6.png',
    '/images/partner-7.png',
    '/images/partner-8.png',
    '/images/partner-9.png',
    '/images/partner-10.png',
    '/images/partner-11.png',
    '/images/partner-12.png',
    '/images/partner-13.png',
    '/images/partner-14.png',
    '/images/partner-15.png',
    '/images/partner-16.png',
    '/images/partner-17.png',
    '/images/partner-18.png',
  ],
};
