<?php

namespace Database\Seeders;

use App\Forms\DataTypes;
use App\Forms\InputFieldNames;
use Illuminate\Database\Seeder;
use App\Models\Sections\SectionType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class SectionTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        SectionType::create(['type' => 'hero_slider', 'cover_image' => '/admin/images/section_types/hero_slider.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'static_hero', 'cover_image' => '/admin/images/section_types/static_hero.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::SUBTITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::DESCRIPTION, 'data_type' => DataTypes::TEXT],
                ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'counter', 'cover_image' => '/admin/images/section_types/counter.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'solutions', 'cover_image' => '/admin/images/section_types/solutions.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'horizontal_scroll', 'cover_image' => '/admin/images/section_types/horizontal_scroll.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'industries', 'cover_image' => '/admin/images/section_types/industries.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'industry', 'cover_image' => '/admin/images/section_types/industry.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'industry_tab', 'cover_image' => '/admin/images/section_types/industry_tab.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::LINK, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'industry_content', 'cover_image' => '/admin/images/section_types/industry_content.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'industry_content_list', 'cover_image' => '/admin/images/section_types/industry_content_list.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::LINK, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'cards', 'cover_image' => '/admin/images/section_types/cards.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_TEXT, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_LINK, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'cards_full_width', 'cover_image' => '/admin/images/section_types/cards_full_width.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_TEXT, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_LINK, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'image_link_card', 'cover_image' => '/admin/images/section_types/image_link_card.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'round_image_card', 'cover_image' => '/admin/images/section_types/round_image_card.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'project_card', 'cover_image' => '/admin/images/section_types/project_card.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::ORGANIZATION, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::INDUSTRY, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::SOLUTION, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::PRODUCTS, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::LOCATION, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::WEBSITE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'reviews', 'cover_image' => '/admin/images/section_types/reviews.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_TEXT, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_LINK, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'emphasys', 'cover_image' => '/admin/images/section_types/emphasys.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TEXT_CONTENT, 'data_type' => DataTypes::TEXT],
            ]);

        SectionType::create(['type' => 'emphasys_three_columns', 'cover_image' => '/admin/images/section_types/emphasys_three_columns.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'quote', 'cover_image' => '/admin/images/section_types/quote.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::AUTHOR, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::POSITION, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::DESCRIPTION, 'data_type' => DataTypes::TEXT],
            ]);

        SectionType::create(['type' => 'text_and_video', 'cover_image' => '/admin/images/section_types/text_and_video.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::DESCRIPTION, 'data_type' => DataTypes::TEXT],
                ['name' => InputFieldNames::VIDEO, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'text_and_image', 'cover_image' => '/admin/images/section_types/text_and_image.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TEXT_CONTENT, 'data_type' => DataTypes::TEXT],
                ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_TEXT, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_LINK, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'solutions_image_text', 'cover_image' => '/admin/images/section_types/solutions_image_text.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TITLE_IMAGE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::SUBTITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::DESCRIPTION, 'data_type' => DataTypes::TEXT],
                ['name' => InputFieldNames::BUTTON_TEXT, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_LINK, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'solutions_text_image', 'cover_image' => '/admin/images/section_types/solutions_text_image.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TITLE_IMAGE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::SUBTITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::DESCRIPTION, 'data_type' => DataTypes::TEXT],
                ['name' => InputFieldNames::BUTTON_TEXT, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_LINK, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'contact_us', 'cover_image' => '/admin/images/section_types/contact_us.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_TEXT, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_LINK, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'contact_information', 'cover_image' => '/admin/images/section_types/contact_information.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TEXT_CONTENT, 'data_type' => DataTypes::TEXT],
                ['name' => InputFieldNames::BUTTON_LEFT_TEXT, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_LEFT_LINK, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_CENTER_TEXT, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_CENTER_LINK, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_RIGHT_TEXT, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::BUTTON_RIGHT_LINK, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'single_paragraph', 'cover_image' => '/admin/images/section_types/single_paragraph.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::DESCRIPTION, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'horizontal_rule', 'cover_image' => '/admin/images/section_types/horizontal_rule.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'table', 'cover_image' => '/admin/images/section_types/table.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TEXT_CONTENT, 'data_type' => DataTypes::TEXT],
            ]);

        SectionType::create(['type' => 'tech_partners', 'cover_image' => '/admin/images/section_types/tech_partners.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::SUBTITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'happy_clients', 'cover_image' => '/admin/images/section_types/happy_clients.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ]);

        SectionType::create(['type' => 'article', 'cover_image' => '/admin/images/section_types/article.jpg'])
            ->sectionTypeFields()->createMany([
                ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
                ['name' => InputFieldNames::TEXT_CONTENT, 'data_type' => DataTypes::TEXT],
            ]);
        
    }
}
