<?php

namespace Database\Seeders;

use App\Forms\DataTypes;
use App\Forms\InputFieldNames;
use Illuminate\Database\Seeder;
use App\Models\Sections\SectElType;
use App\Models\Sections\SectionType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class SectElTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $coverImage = 'admin/images/no_image.jpg';

        $sectionTypes = SectionType::all();

        $heroSliderSectionType = $sectionTypes->where('type', 'hero_slider')->first();
        SectElType::create([
            'section_type_id' => $heroSliderSectionType->id,
            'type' => 'hero_slider_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::DESCRIPTION, 'data_type' => DataTypes::TEXT],
            ['name' => InputFieldNames::BUTTON_TEXT, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::BUTTON_LINK, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::BUTTON_RIGHT_TEXT, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::BUTTON_RIGHT_LINK, 'data_type' => DataTypes::STRING],
        ]);

        $counterSectionType = $sectionTypes->where('type', 'counter')->first();
        SectElType::create([
            'section_type_id' => $counterSectionType->id,
            'type' => 'counter_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::NUMBER, 'data_type' => DataTypes::INTEGER],
            ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
        ]);

        $solutionsSectionType = $sectionTypes->where('type', 'solutions')->first();
        SectElType::create([
            'section_type_id' => $solutionsSectionType->id,
            'type' => 'solutions_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::LINK, 'data_type' => DataTypes::STRING],
        ]);

        $horizontalScrollSectionType = $sectionTypes->where('type', 'horizontal_scroll')->first();
        SectElType::create([
            'section_type_id' => $horizontalScrollSectionType->id,
            'type' => 'horizontal_scroll_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::LINK, 'data_type' => DataTypes::STRING],
        ]);

        $industryContentListSectionType = $sectionTypes->where('type', 'industry_content_list')->first();
        SectElType::create([
            'section_type_id' => $industryContentListSectionType->id,
            'type' => 'industry_content_list_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
        ]);

        $cardsSectionType = $sectionTypes->where('type', 'cards')->first();
        SectElType::create([
            'section_type_id' => $cardsSectionType->id,
            'type' => 'card_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::DESCRIPTION, 'data_type' => DataTypes::TEXT],
            ['name' => InputFieldNames::LINK, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::LINK_TEXT, 'data_type' => DataTypes::STRING],
        ]);

        $cardsFullWidthSectionType = $sectionTypes->where('type', 'cards_full_width')->first();
        SectElType::create([
            'section_type_id' => $cardsFullWidthSectionType->id,
            'type' => 'card_full_width_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::DESCRIPTION, 'data_type' => DataTypes::TEXT],
            ['name' => InputFieldNames::LINK, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::LINK_TEXT, 'data_type' => DataTypes::STRING],
        ]);

        $imageLinkCardSectionType = $sectionTypes->where('type', 'image_link_card')->first();
        SectElType::create([
            'section_type_id' => $imageLinkCardSectionType->id,
            'type' => 'image_link_card_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::LINK_TEXT, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::LINK, 'data_type' => DataTypes::STRING],
        ]);

        $roundImageCardSectionType = $sectionTypes->where('type', 'round_image_card')->first();
        SectElType::create([
            'section_type_id' => $roundImageCardSectionType->id,
            'type' => 'round_image_card_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::POSITION, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::LINK, 'data_type' => DataTypes::STRING],
        ]);

        $reviewsSectionType = $sectionTypes->where('type', 'reviews')->first();
        SectElType::create([
            'section_type_id' => $reviewsSectionType->id,
            'type' => 'review_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::TEXT_CONTENT, 'data_type' => DataTypes::TEXT],
            ['name' => InputFieldNames::AUTHOR, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::POSITION, 'data_type' => DataTypes::STRING],
        ]);

        $emphasysThreeColumnsSectionType = $sectionTypes->where('type', 'emphasys_three_columns')->first();
        SectElType::create([
            'section_type_id' => $emphasysThreeColumnsSectionType->id,
            'type' => 'emphasys_three_columns_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::DESCRIPTION, 'data_type' => DataTypes::TEXT],
        ]);

        $techPartnersSectionType = $sectionTypes->where('type', 'tech_partners')->first();
        SectElType::create([
            'section_type_id' => $techPartnersSectionType->id,
            'type' => 'tech_partner_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
        ]);

        $happyClientsSectionType = $sectionTypes->where('type', 'happy_clients')->first();
        SectElType::create([
            'section_type_id' => $happyClientsSectionType->id,
            'type' => 'happy_client_item',
            'cover_image' => $coverImage
        ])->fields()->createMany([
            ['name' => InputFieldNames::IMAGE, 'data_type' => DataTypes::STRING],
            ['name' => InputFieldNames::TITLE, 'data_type' => DataTypes::STRING],
        ]);
    }
}
