<?php

namespace Database\Seeders;

use App\Models\Page;
use App\Models\PageType;
use App\Forms\InputFieldNames;
use Illuminate\Database\Seeder;
use App\Models\Sections\SectElType;
use Database\Factories\PageFactory;
use App\Models\Sections\SectionType;
use App\Models\Sections\SectElTypeField;
use App\Models\Sections\SectionTypeField;

class PageSeeder extends Seeder
{
    private function createHomeHeroSliderSection($homePage)
    {
        $heroSliderSectionType = SectionType::where('type', 'hero_slider')->first();
        $heroSliderSectionTypeFields = SectionTypeField::where('section_type_id', $heroSliderSectionType->id)->get();
        $heroSliderSection = $homePage->sections()->create([
            'section_type_id' => $heroSliderSectionType->id,
            'is_active' => 1,
        ]);

        $heroSliderSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $heroSliderSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Secure Your Future, Automate Your Present'],
                'en' => ['string_value' => 'Secure Your Future, Automate Your Present'],
            ],
        ]);

        $heroSliderItemSectionType = SectElType::where('type', 'hero_slider_item')->first();
        $heroSliderItemSectionTypeFields = SectElTypeField::where('sect_el_type_id', $heroSliderItemSectionType->id)->get();

        $heroSliderItemOneSlide = $heroSliderSection->sectionElements()->create([
            'sect_el_type_id' => $heroSliderItemSectionType->id,
            'admin_title' => 'hero_slider_item_1',
            'is_active' => 1,
            'cover_image' => 'files/img-slider-1.jpg',
        ]);

        $heroSliderItemOneSlide->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/img-slider-1.jpg'],
                'en' => ['string_value' => 'files/img-slider-1.jpg'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'ВИСОКО НИВО НА КИБЕРСИГУРНОСТ NIS-0 '],
                'en' => ['string_value' => 'HIGH LEVEL OF CYBERSECURITY NIS-0'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Европейската директива за мрежова и информационна сигурност NIS2 влeзe в сила на 17 октомври 2024г. Парафлоу ще ви консултира да приведете вашата организация в съответствие с Директивата и да постигнете високо ниво на киберсигурност и оперативна устойчивост.'],
                'en' => ['text_value' => 'The European Directive on Network and Information Security NIS2 comes into force on 17 October 2024. Paraflow will consult you to bring your organization into compliance with the Directive and achieve high levels of cyber security and operational resilience.'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::BUTTON_TEXT)->first()->id,
                'bg' => ['string_value' => 'Научете повече'],
                'en' => ['string_value' => 'Learn More'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::BUTTON_LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::BUTTON_RIGHT_TEXT)->first()->id,
                'bg' => ['string_value' => 'Научете повече'],
                'en' => ['string_value' => 'Learn More'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::BUTTON_RIGHT_LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $heroSliderItemTwoSlide = $heroSliderSection->sectionElements()->create([
            'sect_el_type_id' => $heroSliderItemSectionType->id,
            'admin_title' => 'hero_slider_item_2',
            'is_active' => 1,
            'cover_image' => 'files/img-slider-2.jpg',
        ]);

        $heroSliderItemTwoSlide->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/img-slider-2.jpg'],
                'en' => ['string_value' => 'files/img-slider-2.jpg'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'ВИСОКО НИВО НА КИБЕРСИГУРНОСТ NIS-0 '],
                'en' => ['string_value' => 'HIGH LEVEL OF CYBERSECURITY NIS-0'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Европейската директива за мрежова и информационна сигурност NIS2 влeзe в сила на 17 октомври 2024г. Парафлоу ще ви консултира да приведете вашата организация в съответствие с Директивата и да постигнете високо ниво на киберсигурност и оперативна устойчивост.'],
                'en' => ['text_value' => 'The European Directive on Network and Information Security NIS2 comes into force on 17 October 2024. Paraflow will consult you to bring your organization into compliance with the Directive and achieve high levels of cyber security and operational resilience.'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::BUTTON_TEXT)->first()->id,
                'bg' => ['string_value' => 'Научете повече'],
                'en' => ['string_value' => 'Learn More'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::BUTTON_LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::BUTTON_RIGHT_TEXT)->first()->id,
                'bg' => ['string_value' => 'Научете повече'],
                'en' => ['string_value' => 'Learn More'],
            ],
            [
                'sect_el_type_field_id' => $heroSliderItemSectionTypeFields->where('name', InputFieldNames::BUTTON_RIGHT_LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);
    }

    private function createHomeCounterSection($homePage)
    {
        $counterSectionType = SectionType::where('type', 'counter')->first();
        $counterSectionTypeFields = SectionTypeField::where('section_type_id', $counterSectionType->id)->get();

        $counterSection = $homePage->sections()->create([
            'section_type_id' => $counterSectionType->id,
            'is_active' => 1,
        ]);

        $counterSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $counterSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Нашите постижения'],
                'en' => ['string_value' => 'Our Achievements'],
            ],
        ]);

        $counterItemSectionType = SectElType::where('type', 'counter_item')->first();
        $counterItemSectionTypeFields = SectElTypeField::where('sect_el_type_id', $counterItemSectionType->id)->get();

        $counterItemProjects = $counterSection->sectionElements()->create([
            'sect_el_type_id' => $counterItemSectionType->id,
            'admin_title' => 'counter_item_projects',
            'is_active' => 1,
        ]);

        $counterItemProjects->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $counterItemSectionTypeFields->where('name', InputFieldNames::NUMBER)->first()->id,
                'bg' => ['int_value' => 1500],
                'en' => ['int_value' => 1500],
            ],
            [
                'sect_el_type_field_id' => $counterItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Реализирани проекти'],
                'en' => ['string_value' => 'Completed Projects'],
            ],
        ]);

        $counterItemLeading = $counterSection->sectionElements()->create([
            'sect_el_type_id' => $counterItemSectionType->id,
            'admin_title' => 'counter_item_leading',
            'is_active' => 1,
        ]);

        $counterItemLeading->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $counterItemSectionTypeFields->where('name', InputFieldNames::NUMBER)->first()->id,
                'bg' => ['int_value' => 30],
                'en' => ['int_value' => 30],
            ],
            [
                'sect_el_type_field_id' => $counterItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Водещ системен интегратор'],
                'en' => ['string_value' => 'Leading System Integrator'],
            ],
        ]);

        $counterItemClients = $counterSection->sectionElements()->create([
            'sect_el_type_id' => $counterItemSectionType->id,
            'admin_title' => 'counter_item_clients',
            'is_active' => 1,
        ]);

        $counterItemClients->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $counterItemSectionTypeFields->where('name', InputFieldNames::NUMBER)->first()->id,
                'bg' => ['int_value' => 500],
                'en' => ['int_value' => 500],
            ],
            [
                'sect_el_type_field_id' => $counterItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Доволствени клиенти'],
                'en' => ['string_value' => 'Satisfied Clients'],
            ],
        ]);

        $counterItemPartners = $counterSection->sectionElements()->create([
            'sect_el_type_id' => $counterItemSectionType->id,
            'admin_title' => 'counter_item_partners',
            'is_active' => 1,
        ]);

        $counterItemPartners->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $counterItemSectionTypeFields->where('name', InputFieldNames::NUMBER)->first()->id,
                'bg' => ['int_value' => 50],
                'en' => ['int_value' => 50],
            ],
            [
                'sect_el_type_field_id' => $counterItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Технологични партньори'],
                'en' => ['string_value' => 'Technology Partners'],
            ],
        ]);
    }

    private function createHomeSolutionsSection($homePage)
    {
        $solutionsSectionType = SectionType::where('type', 'solutions')->first();
        $solutionsSectionTypeFields = SectionTypeField::where('section_type_id', $solutionsSectionType->id)->get();

        $solutionsSection = $homePage->sections()->create([
            'section_type_id' => $solutionsSectionType->id,
            'is_active' => 1,
        ]);

        $solutionsSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $solutionsSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Решения'],
                'en' => ['string_value' => 'Solutions'],
            ],
        ]);

        $solutionsItemSectionType = SectElType::where('type', 'solutions_item')->first();
        $solutionsItemSectionTypeFields = SectElTypeField::where('sect_el_type_id', $solutionsItemSectionType->id)->get();

        $solutionsItemOne = $solutionsSection->sectionElements()->create([
            'sect_el_type_id' => $solutionsItemSectionType->id,
            'admin_title' => 'solutions_item_1',
            'is_active' => 1,
        ]);

        $solutionsItemOne->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Дигитална трансформация'],
                'en' => ['string_value' => 'Digital Transformation'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/icon-solution-1.svg'],
                'en' => ['string_value' => 'files/icon-solution-1.svg'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $solutionsItemTwo = $solutionsSection->sectionElements()->create([
            'sect_el_type_id' => $solutionsItemSectionType->id,
            'admin_title' => 'solutions_item_2',
            'is_active' => 1,
        ]);

        $solutionsItemTwo->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Мрежови решения'],
                'en' => ['string_value' => 'Network Solutions'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/icon-solution-2.svg'],
                'en' => ['string_value' => 'files/icon-solution-2.svg'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $solutionsItemThree = $solutionsSection->sectionElements()->create([
            'sect_el_type_id' => $solutionsItemSectionType->id,
            'admin_title' => 'solutions_item_3',
            'is_active' => 1,
        ]);

        $solutionsItemThree->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Центрове за данни'],
                'en' => ['string_value' => 'Data Centers'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/icon-solution-3.svg'],
                'en' => ['string_value' => 'files/icon-solution-3.svg'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $solutionsItemFour = $solutionsSection->sectionElements()->create([
            'sect_el_type_id' => $solutionsItemSectionType->id,
            'admin_title' => 'solutions_item_4',
            'is_active' => 1,
        ]);

        $solutionsItemFour->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'ИТ инфраструктура'],
                'en' => ['string_value' => 'IT Infrastructure'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/icon-solution-4.svg'],
                'en' => ['string_value' => 'files/icon-solution-4.svg'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $solutionsItemFive = $solutionsSection->sectionElements()->create([
            'sect_el_type_id' => $solutionsItemSectionType->id,
            'admin_title' => 'solutions_item_5',
            'is_active' => 1,
        ]);

        $solutionsItemFive->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Киберсигурност'],
                'en' => ['string_value' => 'Cybersecurity'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/icon-solution-5.svg'],
                'en' => ['string_value' => 'files/icon-solution-5.svg'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $solutionsItemSix = $solutionsSection->sectionElements()->create([
            'sect_el_type_id' => $solutionsItemSectionType->id,
            'admin_title' => 'solutions_item_6',
            'is_active' => 1,
        ]);

        $solutionsItemSix->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Техническо обслужване'],
                'en' => ['string_value' => 'Technical Support'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/icon-solution-6.svg'],
                'en' => ['string_value' => 'files/icon-solution-6.svg'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $solutionsItemSeven = $solutionsSection->sectionElements()->create([
            'sect_el_type_id' => $solutionsItemSectionType->id,
            'admin_title' => 'solutions_item_7',
            'is_active' => 1,
        ]);

        $solutionsItemSeven->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Консултантски дейности'],
                'en' => ['string_value' => 'Consulting Activities'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/icon-solution-7.svg'],
                'en' => ['string_value' => 'files/icon-solution-7.svg'],
            ],
            [
                'sect_el_type_field_id' => $solutionsItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);
    }

    private function createHomeHorizontalSection($homePage)
    {
        $horizontalScrollSectionType = SectionType::where('type', 'horizontal_scroll')->first();
        $horizontalScrollSectionTypeFields = SectionTypeField::where('section_type_id', $horizontalScrollSectionType->id)->get();

        $horizontalScrollSection = $homePage->sections()->create([
            'section_type_id' => $horizontalScrollSectionType->id,
            'is_active' => 1,
        ]);

        $horizontalScrollSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $horizontalScrollSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'horizontal_scroll'],
                'en' => ['string_value' => 'horizontal_scroll'],
            ],
        ]);

        $horizontalScrollItemSectionType = SectElType::where('type', 'horizontal_scroll_item')->first();
        $horizontalScrollItemSectionTypeFields = SectElTypeField::where('sect_el_type_id', $horizontalScrollItemSectionType->id)->get();

        for ($i = 1; $i <= 19; $i++) {
            $horizontalScrollItem = $horizontalScrollSection->sectionElements()->create([
                'sect_el_type_id' => $horizontalScrollItemSectionType->id,
                'admin_title' => 'horizontal_scroll_item_' . $i,
                'is_active' => 1,
            ]);

            $horizontalScrollItem->sectElFields()->createMany([
                [
                    'sect_el_type_field_id' => $horizontalScrollItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                    'bg' => ['string_value' => 'files/partner-' . $i . '.png'],
                    'en' => ['string_value' => 'files/partner-' . $i . '.png'],
                ],
                [
                    'sect_el_type_field_id' => $horizontalScrollItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                    'bg' => ['string_value' => '#'],
                    'en' => ['string_value' => '#'],
                ],
            ]);
        }
    }

    private function createHomeIndustrySection($homePage)
    {
        $industriesSectionType = SectionType::where('type', 'industries')->first();
        $industriesSectionTypeFields = SectionTypeField::where('section_type_id', $industriesSectionType->id)->get();

        $industriesSection = $homePage->sections()->create([
            'section_type_id' => $industriesSectionType->id,
            'is_active' => 1,
        ]);

        $industriesSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $industriesSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Индустрии'],
                'en' => ['string_value' => 'Industries'],
            ],
        ]);

        $industrySectionType = SectionType::where('type', 'industry')->first();
        $industrySectionTypeFields = SectionTypeField::where('section_type_id', $industrySectionType->id)->get();

        $financeSection = $homePage->sections()->create([
            'section_type_id' => $industrySectionType->id,
            'is_active' => 1,
            'parent_id' => $industriesSection->id,
        ]);

        $financeSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $industrySectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Финанси'],
                'en' => ['string_value' => 'Finance'],
            ],
        ]);

        $industryTabSectionType = SectionType::where('type', 'industry_tab')->first();
        $industryTabSectionTypeFields = SectionTypeField::where('section_type_id', $industryTabSectionType->id)->get();

        $financeTabSection = $homePage->sections()->create([
            'section_type_id' => $industryTabSectionType->id,
            'is_active' => 1,
            'parent_id' => $financeSection->id,
        ]);

        $financeTabSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $industryTabSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Финанси'],
                'en' => ['string_value' => 'Finance'],
            ],
            [
                'section_type_field_id' => $industryTabSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/icon-industry-1.png'],
                'en' => ['string_value' => 'files/icon-industry-1.png'],
            ],
            [
                'section_type_field_id' => $industryTabSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $industryContentSectionType = SectionType::where('type', 'industry_content')->first();
        $industryContentSectionTypeFields = SectionTypeField::where('section_type_id', $industryContentSectionType->id)->get();

        $financeContentSection = $homePage->sections()->create([
            'section_type_id' => $industryContentSectionType->id,
            'is_active' => 1,
            'parent_id' => $financeSection->id,
        ]);

        $financeContentSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $industryContentSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Подходящи решения Финанси'],
                'en' => ['string_value' => 'Suitable Solutions Finance'],
            ],
        ]);

        $industryContentListSectionType = SectionType::where('type', 'industry_content_list')->first();
        $industryContentListSectionTypeFields = SectionTypeField::where('section_type_id', $industryContentListSectionType->id)->get();

        $financeContentListSection = $homePage->sections()->create([
            'section_type_id' => $industryContentListSectionType->id,
            'is_active' => 1,
            'parent_id' => $financeContentSection->id,
        ]);

        $financeContentListSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $industryContentListSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Дигитална трансформация Финанси'],
                'en' => ['string_value' => 'Digital Transformation Finance'],
            ],
            [
                'section_type_field_id' => $industryContentListSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $industryContentListItemSectionType = SectElType::where('type', 'industry_content_list_item')->first();
        $industryContentListItemSectionTypeFields = SectElTypeField::where('sect_el_type_id', $industryContentListItemSectionType->id)->get();

        $financeContentListItemOne = $financeContentListSection->sectionElements()->create([
            'sect_el_type_id' => $industryContentListItemSectionType->id,
            'admin_title' => 'finance_content_list_item_1',
            'is_active' => 1,
        ]);

        $financeContentListItemOne->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $industryContentListItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Управление на взаимоотношенията с клиентите'],
                'en' => ['string_value' => 'Customer Relationship Management'],
            ],
        ]);

        $financeContentListItemTwo = $financeContentListSection->sectionElements()->create([
            'sect_el_type_id' => $industryContentListItemSectionType->id,
            'admin_title' => 'finance_content_list_item_2',
            'is_active' => 1,
        ]);

        $financeContentListItemTwo->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $industryContentListItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Бизнес анализи и отчети'],
                'en' => ['string_value' => 'Business Analysis and Reports'],
            ],
        ]);

        $financeContentListItemThree = $financeContentListSection->sectionElements()->create([
            'sect_el_type_id' => $industryContentListItemSectionType->id,
            'admin_title' => 'finance_content_list_item_3',
            'is_active' => 1,
        ]);

        $financeContentListItemThree->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $industryContentListItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Съвместна работа и организация на работни процеси'],
                'en' => ['string_value' => 'Co-operation and organization of work processes'],
            ],
        ]);

        $financeContentListItemFour = $financeContentListSection->sectionElements()->create([
            'sect_el_type_id' => $industryContentListItemSectionType->id,
            'admin_title' => 'finance_content_list_item_4',
            'is_active' => 1,
        ]);

        $financeContentListItemFour->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $industryContentListItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Контактни центрове'],
                'en' => ['string_value' => 'Contact Centers'],
            ],
        ]);


        $publicSectorSection = $homePage->sections()->create([
            'section_type_id' => $industrySectionType->id,
            'is_active' => 1,
            'parent_id' => $industriesSection->id,
        ]);

        $publicSectorSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $industrySectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Публичен сектор'],
                'en' => ['string_value' => 'Public Sector'],
            ],
        ]);

        $publicSectorTabSection = $homePage->sections()->create([
            'section_type_id' => $industryTabSectionType->id,
            'is_active' => 1,
            'parent_id' => $publicSectorSection->id,
        ]);

        $publicSectorTabSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $industryTabSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Публичен сектор'],
                'en' => ['string_value' => 'Public Sector'],
            ],
            [
                'section_type_field_id' => $industryTabSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/icon-industry-2.png'],
                'en' => ['string_value' => 'files/icon-industry-2.png'],
            ],
            [
                'section_type_field_id' => $industryTabSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $publicSectorContentSection = $homePage->sections()->create([
            'section_type_id' => $industryContentSectionType->id,
            'is_active' => 1,
            'parent_id' => $publicSectorSection->id,
        ]);

        $publicSectorContentSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $industryContentSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Подходящи решения Публичен сектор'],
                'en' => ['string_value' => 'Suitable Solutions Public Sector'],
            ],
        ]);

        $publicSectorContentListSection = $homePage->sections()->create([
            'section_type_id' => $industryContentListSectionType->id,
            'is_active' => 1,
            'parent_id' => $publicSectorContentSection->id,
        ]);

        $publicSectorContentListSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $industryContentListSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Дигитална трансформация Публичен сектор'],
                'en' => ['string_value' => 'Digital Transformation Public Sector'],
            ],
            [
                'section_type_field_id' => $industryContentListSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $publicSectorContentListItemOne = $publicSectorContentListSection->sectionElements()->create([
            'sect_el_type_id' => $industryContentListItemSectionType->id,
            'admin_title' => 'industry_content_list_item_1',
            'is_active' => 1,
        ]);

        $publicSectorContentListItemOne->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $industryContentListItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Управление на взаимоотношенията с клиентите'],
                'en' => ['string_value' => 'Customer Relationship Management'],
            ],
        ]);

        $publicSectorContentListItemTwo = $publicSectorContentListSection->sectionElements()->create([
            'sect_el_type_id' => $industryContentListItemSectionType->id,
            'admin_title' => 'public_sector_content_list_item_2',
            'is_active' => 1,
        ]);

        $publicSectorContentListItemTwo->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $industryContentListItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Бизнес анализи и отчети'],
                'en' => ['string_value' => 'Business Analysis and Reports'],
            ],
        ]);

        $publicSectorContentListItemThree = $publicSectorContentListSection->sectionElements()->create([
            'sect_el_type_id' => $industryContentListItemSectionType->id,
            'admin_title' => 'public_sector_content_list_item_3',
            'is_active' => 1,
        ]);

        $publicSectorContentListItemThree->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $industryContentListItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Съвместна работа и организация на работни процеси'],
                'en' => ['string_value' => 'Co-operation and organization of work processes'],
            ],
        ]);

        $publicSectorContentListItemFour = $publicSectorContentListSection->sectionElements()->create([
            'sect_el_type_id' => $industryContentListItemSectionType->id,
            'admin_title' => 'public_sector_content_list_item_4',
            'is_active' => 1,
        ]);

        $publicSectorContentListItemFour->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $industryContentListItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Контактни центрове'],
                'en' => ['string_value' => 'Contact Centers'],
            ],
        ]);
    }

    private function createHomeCardsSection($homePage)
    {
        $cardsSectionType = SectionType::where('type', 'cards')->first();
        $cardsSectionTypeFields = SectionTypeField::where('section_type_id', $cardsSectionType->id)->get();

        $cardsNoTitleSection = $homePage->sections()->create([
            'section_type_id' => $cardsSectionType->id,
            'is_active' => 1,
        ]);

        $cardsNoTitleSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $cardsSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'no_title'],
                'en' => ['string_value' => 'no_title'],
            ],
            [
                'section_type_field_id' => $cardsSectionTypeFields->where('name', InputFieldNames::BUTTON_TEXT)->first()->id,
                'bg' => ['string_value' => 'Още продукти'],
                'en' => ['string_value' => 'More Products'],
            ],
            [
                'section_type_field_id' => $cardsSectionTypeFields->where('name', InputFieldNames::BUTTON_LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ]
        ]);
        $cardItemSectionType = SectElType::where('type', 'card_item')->first();
        $cardItemSectionTypeFields = SectElTypeField::where('sect_el_type_id', $cardItemSectionType->id)->get();

        $cardItemOne = $cardsNoTitleSection->sectionElements()->create([
            'sect_el_type_id' => $cardItemSectionType->id,
            'admin_title' => 'card_item_1',
            'is_active' => 1,
        ]);

        $cardItemOne->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/img-1-4.jpg'],
                'en' => ['string_value' => 'files/img-1-4.jpg'],
            ],
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Американският университет в България с технологична платформа за интерактивно обучениe'],
                'en' => ['text_value' => 'American University in Bulgaria with a technological platform for interactive training'],
            ],
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::LINK_TEXT)->first()->id,
                'bg' => ['string_value' => 'Научете повече'],
                'en' => ['string_value' => 'Learn More'],
            ],
        ]);

        $cardItemTwo = $cardsNoTitleSection->sectionElements()->create([
            'sect_el_type_id' => $cardItemSectionType->id,
            'admin_title' => 'card_item_2',
            'is_active' => 1,
        ]);

        $cardItemTwo->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/img-1-1.jpg'],
                'en' => ['string_value' => 'files/img-1-1.jpg'],
            ],
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Внедряване на център за обслужване на клиенти в Софарма Трейдинг и интеграция с другите системи на компанията'],
                'en' => ['text_value' => 'Implementation of a customer service center in Sofarma Trading and integration with other company systems'],
            ],
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::LINK_TEXT)->first()->id,
                'bg' => ['string_value' => 'Научете повече'],
                'en' => ['string_value' => 'Learn More'],
            ],
        ]);

        $cardItemThree = $cardsNoTitleSection->sectionElements()->create([
            'sect_el_type_id' => $cardItemSectionType->id,
            'admin_title' => 'card_item_3',
            'is_active' => 1,
        ]);

        $cardItemThree->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/img-1-5.jpg'],
                'en' => ['string_value' => 'files/img-1-5.jpg'],
            ],
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Изграждане на частен облак за ИТ инфраструктурата на УниКредит Булбанк'],
                'en' => ['text_value' => 'Building a private cloud for the IT infrastructure of UniCredit Bulbank'],
            ],
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
            [
                'sect_el_type_field_id' => $cardItemSectionTypeFields->where('name', InputFieldNames::LINK_TEXT)->first()->id,
                'bg' => ['string_value' => 'Научете повече'],
                'en' => ['string_value' => 'Learn More'],
            ],
        ]);
    }

    private function createCardsFullWidthSection($page)
    {
        $cardsFullWidthSectionType = SectionType::where('type', 'cards_full_width')->first();
        $cardsFullWidthSectionTypeFields = SectionTypeField::where('section_type_id', $cardsFullWidthSectionType->id)->get();

        $cardsFullWidthSection = $page->sections()->create([
            'section_type_id' => $cardsFullWidthSectionType->id,
            'is_active' => 1,
        ]);

        $cardsFullWidthSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $cardsFullWidthSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'no_title'],
                'en' => ['string_value' => 'no_title'],
            ],
            [
                'section_type_field_id' => $cardsFullWidthSectionTypeFields->where('name', InputFieldNames::BUTTON_TEXT)->first()->id,
                'bg' => ['string_value' => 'Още продукти'],
                'en' => ['string_value' => 'More products'],
            ],
            [
                'section_type_field_id' => $cardsFullWidthSectionTypeFields->where('name', InputFieldNames::BUTTON_LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $cardFullWidthItemSectionType = SectElType::where('type', 'card_full_width_item')->first();
        $cardFullWidthItemSectionTypeFields = SectElTypeField::where('sect_el_type_id', $cardFullWidthItemSectionType->id)->get();

        $cardFullWidthItemOne = $cardsFullWidthSection->sectionElements()->create([
            'sect_el_type_id' => $cardFullWidthItemSectionType->id,
            'admin_title' => 'card_full_width_item_1',
            'is_active' => 1,
        ]);

        $cardFullWidthItemOne->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/img-1-1.jpg'],
                'en' => ['string_value' => 'files/img-1-1.jpg'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'HP & Poly - решения за вашата работна среда'],
                'en' => ['string_value' => 'HP & Poly - solutions for your workplace'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Хибридната работа позволява с подходящите устройства и инструменти хората да станат не само по-продуктивни, но и по-мотивирани.'],
                'en' => ['text_value' => 'Hybrid work allows people to become not only more productive, but also more motivated with the right devices and tools.'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::LINK_TEXT)->first()->id,
                'bg' => ['string_value' => 'Научете повече'],
                'en' => ['string_value' => 'Learn More'],
            ],
        ]);

        $cardFullWidthItemTwo = $cardsFullWidthSection->sectionElements()->create([
            'sect_el_type_id' => $cardFullWidthItemSectionType->id,
            'admin_title' => 'card_full_width_item_2',
            'is_active' => 1,
        ]);

        $cardFullWidthItemTwo->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/img-1-2.jpg'],
                'en' => ['string_value' => 'files/img-1-2.jpg'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Нови HP А4 цветни лазерни устройства'],
                'en' => ['string_value' => 'New HP A4 color laser devices'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Възползвайте се от нашите специални предложения за HP А4 цветни лазерни устройства'],
                'en' => ['text_value' => 'Take advantage of our special offers for HP A4 color laser devices'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::LINK_TEXT)->first()->id,
                'bg' => ['string_value' => 'Научете повече'],
                'en' => ['string_value' => 'Learn More'],
            ],
        ]);

        $cardFullWidthItemThree = $cardsFullWidthSection->sectionElements()->create([
            'sect_el_type_id' => $cardFullWidthItemSectionType->id,
            'admin_title' => 'card_full_width_item_3',
            'is_active' => 1,
        ]);

        $cardFullWidthItemThree->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/img-1-2.jpg'],
                'en' => ['string_value' => 'files/img-1-2.jpg'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Нови HP А4 цветни лазерни устройства'],
                'en' => ['string_value' => 'New HP A4 color laser devices'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Възползвайте се от нашите специални предложения за HP А4 цветни лазерни устройства'],
                'en' => ['text_value' => 'Take advantage of our special offers for HP A4 color laser devices'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
            [
                'sect_el_type_field_id' => $cardFullWidthItemSectionTypeFields->where('name', InputFieldNames::LINK_TEXT)->first()->id,
                'bg' => ['string_value' => 'Научете повече'],
                'en' => ['string_value' => 'Learn More'],
            ],
        ]);
    }

    private function createHomeReviewsSection($homePage)
    {
        $reviewsSectionType = SectionType::where('type', 'reviews')->first();
        $reviewsSectionTypeFields = SectionTypeField::where('section_type_id', $reviewsSectionType->id)->get();

        $reviewsSection = $homePage->sections()->create([
            'section_type_id' => $reviewsSectionType->id,
            'is_active' => 1,
        ]);

        $reviewsSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $reviewsSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Отзиви'],
                'en' => ['string_value' => 'Reviews'],
            ],
            [
                'section_type_field_id' => $reviewsSectionTypeFields->where('name', InputFieldNames::BUTTON_TEXT)->first()->id,
                'bg' => ['string_value' => 'Научете повече'],
                'en' => ['string_value' => 'Learn More'],
            ],
            [
                'section_type_field_id' => $reviewsSectionTypeFields->where('name', InputFieldNames::BUTTON_LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);

        $reviewItemSectionType = SectElType::where('type', 'review_item')->first();
        $reviewItemSectionTypeFields = SectElTypeField::where('sect_el_type_id', $reviewItemSectionType->id)->get();

        $reviewItemOne = $reviewsSection->sectionElements()->create([
            'sect_el_type_id' => $reviewItemSectionType->id,
            'admin_title' => 'review_item_1',
            'is_active' => 1,
        ]);

        $reviewItemOne->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $reviewItemSectionTypeFields->where('name', InputFieldNames::TEXT_CONTENT)->first()->id,
                'bg' => ['text_value' => 'Миграцията на Фондация "Америка за България" към облачна инфраструктура, осъществено от висококвалифицирания екип на Парафлоу, демонстрира силата на модерните облачни технологии за трансформиране на ИТ инфраструктурата. Внедряването на модерните решения за сигурност и управление добави още едно ниво на защита и контрол, което е от съществено значение за сигурността и ефективността на организацията. Сега фондацията разполага с мощна, сигурна и адаптивна ИТ среда, която ѝ позволява да продължи своята дейност и мисия.'],
                'en' => ['text_value' => 'The migration of the Foundation "America for Bulgaria" to cloud infrastructure, implemented by the highly qualified team of Paraflow, demonstrates the power of modern cloud technologies to transform IT infrastructure. The implementation of modern security and management solutions added another level of protection and control, which is essential for the security and efficiency of the organization. Now the foundation has a powerful, secure and adaptable IT environment that allows it to continue its work and mission.'],
            ],
            [
                'sect_el_type_field_id' => $reviewItemSectionTypeFields->where('name', InputFieldNames::AUTHOR)->first()->id,
                'bg' => ['string_value' => 'Крум Карадаков'],
                'en' => ['string_value' => 'Krum Karadakov'],
            ],
            [
                'sect_el_type_field_id' => $reviewItemSectionTypeFields->where('name', InputFieldNames::POSITION)->first()->id,
                'bg' => ['string_value' => 'Фондация "Америка за България'],
                'en' => ['string_value' => 'Foundation "America for Bulgaria"'],
            ],
        ]);

        $reviewItemTwo = $reviewsSection->sectionElements()->create([
            'sect_el_type_id' => $reviewItemSectionType->id,
            'admin_title' => 'review_item_2',
            'is_active' => 1,
        ]);

        $reviewItemTwo->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $reviewItemSectionTypeFields->where('name', InputFieldNames::TEXT_CONTENT)->first()->id,
                'bg' => ['text_value' => 'Благодарение на извършените модернизации са налице резултати като повишена отчетност и проследимост на ресурсите, по-добра структурираност на информацията и предвидимост на финансовите показатели. Внедрените нови системи са едновременно гъвкави и прецизни, като дават възможност за вземане на бързи решения в дружеството въз основа на подробните анализи.'],
                'en' => ['text_value' => 'Thanks to the performed modernizations, there are results such as increased transparency and traceability of resources, better structuring of information and predictability of financial indicators. The new systems are flexible and precise, allowing for quick decisions to be made in the company based on detailed analyses.'],
            ],
            [
                'sect_el_type_field_id' => $reviewItemSectionTypeFields->where('name', InputFieldNames::AUTHOR)->first()->id,
                'bg' => ['string_value' => 'Димитър Костадинов'],
                'en' => ['string_value' => 'Dimitar Kostadinov'],
            ],
            [
                'sect_el_type_field_id' => $reviewItemSectionTypeFields->where('name', InputFieldNames::POSITION)->first()->id,
                'bg' => ['string_value' => 'ДКУЧПППЗВАИ ПРОФОН'],
                'en' => ['string_value' => 'DKUCHPPPAI PROFON'],
            ],
        ]);

        $reviewItemThree = $reviewsSection->sectionElements()->create([
            'sect_el_type_id' => $reviewItemSectionType->id,
            'admin_title' => 'review_item_3',
            'is_active' => 1,
        ]);

        $reviewItemThree->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $reviewItemSectionTypeFields->where('name', InputFieldNames::TEXT_CONTENT)->first()->id,
                'bg' => ['text_value' => 'Парафлоу изгради за нас висококачествена система за управление на съдебни дела. Това отбелязва началото на нов етап за съдебната система, в който чрез информационни технологии служителите и гражданите получават лесен достъп до съдилищата и незабавна информация относно статуса на делата и предстоящите процесуални стъпки. Заедно с нашия ИТ партньор създадохме изключително ефективна и надеждна система за управление на съдебни производства.'],
                'en' => ['text_value' => 'Paraflow has built for us a high-quality system for managing court cases. This marks the beginning of a new stage in the judicial system, where through information technology, the employees and citizens have easy access to the courts and immediate information about the status of cases and upcoming procedural steps. Together with our IT partner, we have created an extremely effective and reliable system for managing court cases.'],
            ],
            [
                'sect_el_type_field_id' => $reviewItemSectionTypeFields->where('name', InputFieldNames::AUTHOR)->first()->id,
                'bg' => ['string_value' => 'Dunstain Fipaumutima MWAUNGULU'],
                'en' => ['string_value' => 'Dunstain Fipaumutima MWAUNGULU'],
            ],
            [
                'sect_el_type_field_id' => $reviewItemSectionTypeFields->where('name', InputFieldNames::POSITION)->first()->id,
                'bg' => ['string_value' => 'Върховен съд на Малави'],
                'en' => ['string_value' => 'Supreme Court of Malawi'],
            ],
        ]);
    }

    private function createProductOneHeroSection($productOnePage)
    {
        $staticHeroSectionType = SectionType::where('type', 'static_hero')->first();
        $staticHeroSectionTypeFields = SectionTypeField::where('section_type_id', $staticHeroSectionType->id)->get();

        $staticHeroSection = $productOnePage->sections()->create([
            'section_type_id' => $staticHeroSectionType->id,
            'is_active' => 1,
        ]);

        $staticHeroSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $staticHeroSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Високо ниво на киберсигурност NIS2'],
                'en' => ['string_value' => 'High level of cyber security NIS2'],
            ],
            [
                'section_type_field_id' => $staticHeroSectionTypeFields->where('name', InputFieldNames::SUBTITLE)->first()->id,
                'bg' => ['string_value' => 'Високо ниво на киберсигурност NIS-1'],
                'en' => ['string_value' => 'High level of cyber security NIS-1'],
            ],
            [
                'section_type_field_id' => $staticHeroSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Европейската директива за мрежова и информационна сигурност NIS2 влeзe в сила на 17 октомври 2024г. Парафлоу ще ви консултира да приведете вашата организация в съответствие с Директивата и да постигнете високо ниво на киберсигурност и оперативна устойчивост.'],
                'en' => ['text_value' => 'The European Directive on Network and Information Security NIS2 comes into force on 17 October 2024. Paraflow will consult you to bring your organization into compliance with the Directive and achieve high levels of cyber security and operational resilience.'],
            ],
            [
                'section_type_field_id' => $staticHeroSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/img-hero-1.jpg'],
                'en' => ['string_value' => 'files/img-hero-1.jpg'],
            ],
        ]);
    }

    private function createProductOneEmphasysSection($productOnePage)
    {
        $emphasysSectionType = SectionType::where('type', 'emphasys')->first();
        $emphasysSectionTypeFields = SectionTypeField::where('section_type_id', $emphasysSectionType->id)->get();

        $emphasysSection = $productOnePage->sections()->create([
            'section_type_id' => $emphasysSectionType->id,
            'is_active' => 1,
        ]);

        $emphasysSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $emphasysSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'no_title'],
                'en' => ['string_value' => 'no_title'],
            ],
            [
                'section_type_field_id' => $emphasysSectionTypeFields->where('name', InputFieldNames::TEXT_CONTENT)->first()->id,
                'bg' => ['text_value' => 'Европейската директива за мрежова и информационна сигурност NIS2 влeзe в сила на 17 октомври 2024г. Парафлоу ще ви консултира да приведете вашата организация в съответствие с Директивата и да постигнете високо ниво на киберсигурност и оперативна устойчивост.'],
                'en' => ['text_value' => 'The European Directive on Network and Information Security NIS2 comes into force on 17 October 2024. Paraflow will consult you to bring your organization into compliance with the Directive and achieve high levels of cyber security and operational resilience.'],
            ],
        ]);
    }

    private function createProductOneTextAndVideoSection($productOnePage)
    {
        $textAndVideoSectionType = SectionType::where('type', 'text_and_video')->first();
        $textAndVideoSectionTypeFields = SectionTypeField::where('section_type_id', $textAndVideoSectionType->id)->get();

        $textAndVideoSection = $productOnePage->sections()->create([
            'section_type_id' => $textAndVideoSectionType->id,
            'is_active' => 1,
        ]);

        $textAndVideoSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $textAndVideoSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Мисията възможна!'],
                'en' => ['string_value' => 'Mission Possible!'],
            ],
            [
                'section_type_field_id' => $textAndVideoSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Европейската директивата за мрежова и информационна сигурност NIS2/МИС2 определя строги стандарти, които целят да подобрят защитата на цифровата инфраструктура в ЕС. Директивата засяга всички критични индустрии и задължава организациите и фирмите, опериращи или доставящи услуги в тях, да се съобразят с изискванията и предписаните мерки. Специален акцент е поставен върху реагирането на инциденти в областта на киберсигурността. Предвидени са задължения за докладване на инциденти и обмен на тази информация между екипите за реагиране на инциденти в областта на киберсигурността на държавите – членки на ЕС.'],
                'en' => ['text_value' => 'The European Network and Information Security Directive NIS2/MIS2 sets strict standards that aim to improve the protection of digital infrastructure in the EU. The directive affects all critical industries and obliges organizations and companies operating or providing services in them to comply with the requirements and prescribed measures. Special emphasis is placed on responding to cybersecurity incidents. Obligations are provided for reporting incidents and exchanging this information between cybersecurity incident response teams of EU Member States.'],
            ],
            [
                'section_type_field_id' => $textAndVideoSectionTypeFields->where('name', InputFieldNames::VIDEO)->first()->id,
                'bg' => ['string_value' => 'https://www.youtube.com/watch?v=bTqVqk7FSmY'],
                'en' => ['string_value' => 'https://www.youtube.com/watch?v=bTqVqk7FSmY'],
            ],
        ]);
    }

    private function createProductOneSecondEmphasysSection($productOnePage)
    {
        $emphasysSectionType = SectionType::where('type', 'emphasys')->first();
        $emphasysSectionTypeFields = SectionTypeField::where('section_type_id', $emphasysSectionType->id)->get();

        $emphasysSection = $productOnePage->sections()->create([
            'section_type_id' => $emphasysSectionType->id,
            'is_active' => 1,
        ]);

        $emphasysSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $emphasysSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Кои са основните области, които засяга NIS2?'],
                'en' => ['string_value' => 'What are the main areas affected by NIS2?'],
            ],
            [
                'section_type_field_id' => $emphasysSectionTypeFields->where('name', InputFieldNames::TEXT_CONTENT)->first()->id,
                'bg' => ['text_value' => '<ul><li>Управление на риска</li><li>Обработка и докладване на инциденти</li><li>Корпоративна отговорност</li><li>Непрекъснатост в бизнеса</li></ul>'],
                'en' => ['text_value' => '<ul><li>Risk management</li><li>Incident handling and reporting</li><li>Corporate responsibility</li><li>Business continuity</li></ul>'],
            ],
        ]);
    }

    private function createProductOneTextAndImageSection($productOnePage)
    {
        $textAndImageSectionType = SectionType::where('type', 'text_and_image')->first();
        $textAndImageSectionTypeFields = SectionTypeField::where('section_type_id', $textAndImageSectionType->id)->get();

        $textAndImageSection = $productOnePage->sections()->create([
            'section_type_id' => $textAndImageSectionType->id,
            'is_active' => 1,
        ]);

        $textAndImageSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $textAndImageSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'С какво може Парафлоу да ви помогне?'],
                'en' => ['string_value' => 'What can Paraflow help you with?'],
            ],
            [
                'section_type_field_id' => $textAndImageSectionTypeFields->where('name', InputFieldNames::TEXT_CONTENT)->first()->id,
                'bg' => ['text_value' => 'Парафлоу, като дългогодишен системен интегратор с богат опит във внедряването и защитата на информационни системи ще ви консултира като: Направи оценка на вашата ИТ инфраструктура и провери до каква степен съответства на изискванията на Директивата. Предложи технологични решения, базирани на водещи производители, като CISCO, PALO ALTO, CHECK POINT, FORTINET, RAPID 7, MICROSOFT, BROADCOM и др., покриващи изцяло вашите нужди. Разработи план за действие за справяне с идентифицираните пропуски и уязвимости, очертаващи стъпките, необходими за постигане на съответствие, както и определяне на ресурсите, необходими за изпълнение на плана. Непрекъснатост в бизнеса Попълнете специално разработен от нашите кибер експерти ВЪПРОСНИК, за да получите препоръки за техническа готовност.'],
                'en' => ['text_value' => 'Paraflow, as a long-standing system integrator with extensive experience in implementing and protecting information systems, will consult you as follows: Make an assessment of your IT infrastructure and check to what extent it meets the requirements of the Directive. Propose technological solutions based on leading manufacturers, such as CISCO, PALO ALTO, CHECK POINT, FORTINET, RAPID 7, MICROSOFT, BROADCOM, etc., covering your entire needs. Develop an action plan to deal with the identified gaps and vulnerabilities, outlining the steps necessary to achieve compliance, as well as determining the resources required to implement the plan. Business continuity Fill out a specially developed by our cyber experts QUESTIONNAIRE, to receive recommendations for technical readiness.'],
            ],
            [
                'section_type_field_id' => $textAndImageSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/image-2-1-1.jpg'],
                'en' => ['string_value' => 'files/image-2-1-1.jpg'],
            ],
            [
                'section_type_field_id' => $textAndImageSectionTypeFields->where('name', InputFieldNames::BUTTON_TEXT)->first()->id,
                'bg' => ['string_value' => 'Въпросник'],
                'en' => ['string_value' => 'Questionnaire'],
            ],
            [
                'section_type_field_id' => $textAndImageSectionTypeFields->where('name', InputFieldNames::BUTTON_LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);
    }

    private function createProductOneContactUsSection($productOnePage)
    {
        $contactUsSectionType = SectionType::where('type', 'contact_us')->first();
        $contactUsSectionTypeFields = SectionTypeField::where('section_type_id', $contactUsSectionType->id)->get();

        $contactUsSection = $productOnePage->sections()->create([
            'section_type_id' => $contactUsSectionType->id,
            'is_active' => 1,
        ]);

        $contactUsSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $contactUsSectionTypeFields->where('name', InputFieldNames::IMAGE)->first()->id,
                'bg' => ['string_value' => 'files/logo-DqNx5P9U.svg'],
                'en' => ['string_value' => 'files/logo-DqNx5P9U.svg'],
            ],
            [
                'section_type_field_id' => $contactUsSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Екипът на Парафлоу Ви очаква за допълнителна информация и консултации!'],
                'en' => ['string_value' => 'The Paraflow team is waiting for additional information and consultations!'],
            ],
            [
                'section_type_field_id' => $contactUsSectionTypeFields->where('name', InputFieldNames::BUTTON_TEXT)->first()->id,
                'bg' => ['string_value' => 'Свържете се с нас'],
                'en' => ['string_value' => 'Contact us'],
            ],
            [
                'section_type_field_id' => $contactUsSectionTypeFields->where('name', InputFieldNames::BUTTON_LINK)->first()->id,
                'bg' => ['string_value' => '#'],
                'en' => ['string_value' => '#'],
            ],
        ]);
    }

    private function createSingleParagraphSection($page)
    {
        $singleParagraphSectionType = SectionType::where('type', 'single_paragraph')->first();
        $singleParagraphSectionTypeFields = SectionTypeField::where('section_type_id', $singleParagraphSectionType->id)->get();

        $singleParagraphSection = $page->sections()->create([
            'section_type_id' => $singleParagraphSectionType->id,
            'is_active' => 1,
        ]);

        $singleParagraphSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $singleParagraphSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'no_title'],
                'en' => ['string_value' => 'no_title'],
            ],
            [
                'section_type_field_id' => $singleParagraphSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Ефективни решения за вашата работна среда от HP и Парафлоу:'],
                'en' => ['text_value' => 'Effective solutions for your work environment from HP and Paraflow:'],
            ],
        ]);
    }

    private function createHorizontalRuleSection($page)
    {
        $horizontalRuleSectionType = SectionType::where('type', 'horizontal_rule')->first();
        $horizontalRuleSectionTypeFields = SectionTypeField::where('section_type_id', $horizontalRuleSectionType->id)->get();

        $horizontalRuleSection = $page->sections()->create([
            'section_type_id' => $horizontalRuleSectionType->id,
            'is_active' => 1,
        ]);

        $horizontalRuleSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $horizontalRuleSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'no_title'],
                'en' => ['string_value' => 'no_title'],
            ],
        ]);
    }

    private function createTableSection($page)
    {
        $tableSectionType = SectionType::where('type', 'table')->first();
        $tableSectionTypeFields = SectionTypeField::where('section_type_id', $tableSectionType->id)->get();

        $tableSection = $page->sections()->create([
            'section_type_id' => $tableSectionType->id,
            'is_active' => 1,
        ]);

        $tableSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $tableSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'no_title'],
                'en' => ['string_value' => 'no_title'],
            ],
            [
                'section_type_field_id' => $tableSectionTypeFields->where('name', InputFieldNames::TEXT_CONTENT)->first()->id,
                'bg' => ['text_value' => '<table>
                        <tbody>
                          <tr>
                            <th class="">Poly Studio X30</th>
                            <th class="">Poly Studio X52</th>
                            <th class="">Poly Studio X70</th>
                          </tr>
                          <tr>
                            <td>All-In-one video bar for small rooms</td>
                            <td>All-in-one video bar for medium rooms</td>
                            <td>All-In-one video bar for large rooms</td>
                          </tr>
                        </tbody>
                  </table>'],
                'en' => ['text_value' => ''],
            ],
        ]);
    }

    private function createEmphasysThreeColumnsSection($page)
    {
        $emphasysThreeColumnsSectionType = SectionType::where('type', 'emphasys_three_columns')->first();
        $emphasysThreeColumnsSectionTypeFields = SectionTypeField::where('section_type_id', $emphasysThreeColumnsSectionType->id)->get();
        $emphasysThreeColumnsItemSectionType = SectElType::where('type', 'emphasys_three_columns_item')->first();
        $emphasysThreeColumnsItemSectionTypeFields = SectElTypeField::where('sect_el_type_id', $emphasysThreeColumnsItemSectionType->id)->get();

        $emphasysThreeColumnsSection = $page->sections()->create([
            'section_type_id' => $emphasysThreeColumnsSectionType->id,
            'is_active' => 1,
        ]);

        $emphasysThreeColumnsSection->sectionFields()->createMany([
            [
                'section_type_field_id' => $emphasysThreeColumnsSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Какви са предимствата?'],
                'en' => ['string_value' => 'What are the benefits?'],
            ],
        ]);

        $one = $emphasysThreeColumnsSection->sectionElements()->create([
            'sect_el_type_id' => $emphasysThreeColumnsItemSectionType->id,
            'admin_title' => 'one',
            'is_active' => 1,
            'cover_image' => 'admin/images/no_image.jpg',
        ]);

        $one->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $emphasysThreeColumnsItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Работа без притеснения'],
                'en' => ['string_value' => 'Work without stress'],
            ],
            [
                'sect_el_type_field_id' => $emphasysThreeColumnsItemSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Потребителите работят с документи и уеб системи по обичайния за тях начин, без да се притесняват от заразяване в организацията.'],
                'en' => ['text_value' => 'Users work with documents and web systems in the usual way, without worrying about infection in the organization.'],
            ],
        ]);

        $two = $emphasysThreeColumnsSection->sectionElements()->create([
            'sect_el_type_id' => $emphasysThreeColumnsItemSectionType->id,
            'admin_title' => 'two',
            'is_active' => 1,
        ]);

        $two->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $emphasysThreeColumnsItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Автоматична защита срещу фишинг атаки'],
                'en' => ['string_value' => 'Automatic protection against phishing attacks'],
            ],
            [
                'sect_el_type_field_id' => $emphasysThreeColumnsItemSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Потребителите не трябва да бъдат обучавани да действат като „детектори за човешки фишинг атаки“'],
                'en' => ['text_value' => 'Users do not need to be trained to act as “detectors for human phishing attacks”'],
            ],
        ]);

        $three = $emphasysThreeColumnsSection->sectionElements()->create([
            'sect_el_type_id' => $emphasysThreeColumnsItemSectionType->id,
            'admin_title' => 'three',
            'is_active' => 1,
        ]);

        $three->sectElFields()->createMany([
            [
                'sect_el_type_field_id' => $emphasysThreeColumnsItemSectionTypeFields->where('name', InputFieldNames::TITLE)->first()->id,
                'bg' => ['string_value' => 'Цялостна защита навсякъде'],
                'en' => ['string_value' => 'Complete protection everywhere'],
            ],
            [
                'sect_el_type_field_id' => $emphasysThreeColumnsItemSectionTypeFields->where('name', InputFieldNames::DESCRIPTION)->first()->id,
                'bg' => ['text_value' => 'Работите безопасно от дома, офиса или по време на път, независимо дали е онлайн или офлайн.'],
                'en' => ['text_value' => 'You work safely from home, office or on the go, whether online or offline.'],
            ],
        ]);
    }

    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pagePagesType = PageType::where('name', 'pages')->first();

        $homePage = Page::create([
            'page_type_id' => $pagePagesType->id,
            'is_active' => 1,
            'cover_image' => 'admin/images/no_image.jpg',
            'en' => [
                'title' => 'Home',
                'description' => 'Home',
                'slug' => 'home',
                'meta_title' => 'Home',
                'meta_description' => 'Home',
            ],
            'bg' => [
                'title' => 'Начало',
                'description' => 'Начало',
                'slug' => 'home',
                'meta_title' => 'Начало',
                'meta_description' => 'Начало',
            ],
        ]);

        $this->createHomeHeroSliderSection($homePage);
        $this->createHomeCounterSection($homePage);
        $this->createHomeSolutionsSection($homePage);
        $this->createHomeHorizontalSection($homePage);
        $this->createHomeIndustrySection($homePage);
        $this->createHomeCardsSection($homePage);
        $this->createCardsFullWidthSection($homePage);
        $this->createHomeReviewsSection($homePage);

        $productPagesType = PageType::where('name', 'products')->first();
        $productOnePage = Page::create([
            'page_type_id' => $productPagesType->id,
            'is_active' => 1,
            'cover_image' => 'admin/images/no_image.jpg',
            'en' => [
                'title' => 'Product One',
                'description' => 'Product One',
                'slug' => 'product-one',
                'meta_title' => 'Product One',
                'meta_description' => 'Product One',
            ],
            'bg' => [
                'title' => 'Продукт 1',
                'description' => 'Продукт 1',
                'slug' => 'product-one',
                'meta_title' => 'Продукт 1',
                'meta_description' => 'Продукт 1',
            ],
        ]);

        $this->createProductOneHeroSection($productOnePage);
        $this->createProductOneEmphasysSection($productOnePage);
        $this->createSingleParagraphSection($productOnePage);
        $this->createHorizontalRuleSection($productOnePage);
        $this->createProductOneTextAndVideoSection($productOnePage);
        $this->createProductOneSecondEmphasysSection($productOnePage);
        $this->createProductOneTextAndImageSection($productOnePage);
        $this->createTableSection($productOnePage);
        $this->createEmphasysThreeColumnsSection($productOnePage);
        $this->createProductOneContactUsSection($productOnePage);
        $this->createCardsFullWidthSection($productOnePage);

        $productsPage = Page::create([
            'page_type_id' => $pagePagesType->id,
            'is_active' => 1,
            'cover_image' => 'admin/images/no_image.jpg',
            'en' => [
                'title' => 'Products',
                'description' => 'Products',
                'slug' => 'products',
                'meta_title' => 'Products',
                'meta_description' => 'Products',
            ],
            'bg' => [
                'title' => 'Продукти',
                'description' => 'Продукти',
                'slug' => 'products',
                'meta_title' => 'Продукти',
                'meta_description' => 'Продукти',
            ],
        ]);

        // Page::factory()->count(10)->create([
        //     'page_type_id' => $productPagesType->id,
        //     'is_active' => 1
        // ]);

        // $projectPagesType = PageType::where('name', 'projects')->first();
        // Page::factory()->count(10)->create([
        //     'page_type_id' => $projectPagesType->id,
        //     'is_active' => 1
        // ]);
    }
}
