<?php

namespace Database\Seeders;

use App\Models\Menu;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class MenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $menuTypesConfig = collect(config('menus.types'));
        $menuTypes = [
            'main' => $menuTypesConfig->where('type', 'main')->first(),
            'fast_links' => $menuTypesConfig->where('type', 'fast_links')->first(),
        ];

        $mainMenu = Menu::create([
            'type' => $menuTypes['main']['id'],
            'is_active' => 1,
            'bg' => [
                'title' => 'Main Menu',
            ],
            'en' => [
                'title' => 'Main Menu',
            ],
        ]);


        $solutionsItem = $mainMenu->menuItems()->create([
            'en' => [
                'title' => 'Solutions',
                'link' => '#',
            ],
            'bg' => [
                'title' => 'Решения',
                'link' => '#',
            ],
        ]);

        $solutionsItem->children()->createMany([
            [
                'menu_id' => $menuTypes['main']['id'],
                'en' => [
                    'title' => 'Дигитална трансформация',
                    'link' => 'digital-transformation',
                ],
                'bg' => [
                    'title' => 'Дигитална трансформация',
                    'link' => 'digital-transformation',
                ],
            ],
        ]);

        $productsItem = $mainMenu->menuItems()->create([
            'en' => [
                'title' => 'Products',
                'link' => '#',
            ],
            'bg' => [
                'title' => 'Продукти',
                'link' => '#',
            ],
        ]);

        $projectsItem = $mainMenu->menuItems()->create([
            'en' => [
                'title' => 'Projects',
                'link' => '#',
            ],
            'bg' => [
                'title' => 'Проекти',
                'link' => '#',
            ],
        ]);

        $aboutUsItem = $mainMenu->menuItems()->create([
            'en' => [
                'title' => 'About Us',
                'link' => '#',
            ],
            'bg' => [
                'title' => 'За нас',
                'link' => '#',
            ],
        ]);

        $clientsAboutAboutUsItem = $aboutUsItem->children()->createMany([
            [
                'menu_id' => $menuTypes['main']['id'],
                'en' => [
                    'title' => 'Clients about us',
                    'link' => '#',
                ],
                'bg' => [
                    'title' => 'Клиенти за нас',
                    'link' => '#',
                ],
            ],
        ]);



        $fastLinksMenu = Menu::create([
            'type' => $menuTypes['fast_links']['id'],
            'is_active' => 1,
            'bg' => [
                'title' => 'Fast Links Menu',
            ],
            'en' => [
                'title' => 'Fast Links Menu',
            ],
        ]);

        $fastLinksMenu->menuItems()->createMany([
            [
                'menu_id' => $menuTypes['fast_links']['id'],
                'en' => [
                    'title' => 'Digital Transformation',
                    'link' => '#',
                ],
                'bg' => [
                    'title' => 'Дигитална трансформация',
                    'link' => '#',
                ],
            ],
            [
                'menu_id' => $menuTypes['fast_links']['id'],
                'en' => [
                    'title' => 'Network Solutions',
                    'link' => '#',
                ],
                'bg' => [
                    'title' => 'Мрежови решения',
                    'link' => '#',
                ],
            ],
            [
                'menu_id' => $menuTypes['fast_links']['id'],
                'en' => [
                    'title' => 'Data Centers',
                    'link' => '#',
                ],
                'bg' => [
                    'title' => 'Центрове за данни',
                    'link' => '#',
                ],
            ],

        ]);
    }
}
