<?php

use App\Models\MenuItem;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('menu_item_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('menu_item_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('locale')->nullable()->index();
            $table->string('title')->fulltext();
            $table->string('link')->fulltext();

            $table->unique(['menu_item_id', 'locale']);

            $table->foreign('locale')
                ->references('locale')
                ->on('languages')
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('menu_item_translations');
    }
};
