<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use App\Models\Sections\SectElField;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sect_el_field_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(SectElField::class)->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('locale', 2);
            $table->integer('int_value')->nullable();
            $table->string('string_value')->nullable();
            $table->text('text_value')->nullable();
            $table->boolean('boolean_value')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sect_el_field_translations');
    }
};
