<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use App\Models\Sections\SectElType;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sect_el_type_fields', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(SectElType::class)->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('name', 20);
            $table->string('data_type', 20);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sect_el_type_fields');
    }
};
