<?php

use App\Models\Sections\SectionType;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sect_el_types', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(SectionType::class)->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('type', 50);
            $table->string('cover_image')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sect_el_types');
    }
};
