<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('domain_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('domain_id')->constrained()->onUpdate('cascade')->onDelete('cascade');
            $table->string('locale')->nullable()->index();
            $table->string('privacy_policy_link')->nullable();

            $table->unique(['domain_id', 'locale']);

            $table->foreign('locale')
                ->references('locale')
                ->on('languages')
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('domain_translations');
    }
};
