<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('image_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('image_id')->constrained()->onUpdate('cascade')->onDelete('cascade');
            $table->string('locale')->nullable()->index();
            $table->string('title')->nullable();
            $table->string('description')->nullable();
            $table->string('alt')->nullable();

            $table->unique(['image_id', 'locale']);

            $table->foreign('locale')
                ->references('locale')
                ->on('languages')
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('image_translations');
    }
};
