<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('page_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('page_id')->constrained()->onUpdate('cascade')->onDelete('cascade');
            $table->string('locale')->nullable()->index();
            $table->string('slug', 100);
            $table->string('title')->fulltext();
            $table->text('description')->fulltext()->nullable();
            $table->string('meta_title', 80)->fulltext()->nullable();
            $table->string('meta_description', 170)->fulltext()->nullable();

            $table->unique(['page_id', 'locale']);
            $table->unique(['slug', 'locale']);

            $table->foreign('locale')
                ->references('locale')
                ->on('languages')
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('page_translations');
    }
};
