<?php

use App\Models\Sections\SectionField;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('section_field_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(SectionField::class)->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('locale', 2);
            $table->integer('int_value')->nullable();
            $table->string('string_value')->nullable();
            $table->text('text_value')->nullable();
            $table->boolean('boolean_value')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('section_field_translations');
    }
};
