<?php

use App\Models\Sections\SectionType;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sections', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(SectionType::class)->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->boolean('is_active')->default(0);
            $table->boolean('is_in_wrapper')->default(0);
            $table->integer('page_type_id')->nullable();
            $table->integer('number_items')->nullable();
            $table->string('cover_image')->nullable();
            $table->integer('sectionable_id');
            $table->string('sectionable_type');

            $table->nestedSet();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sections');
    }
};
