<?php

use App\Models\Sections\SectionType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('section_type_fields', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(SectionType::class)->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('name', 50);
            $table->string('data_type', 50);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('section_type_fields');
    }
};
