<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Page>
 */
class PageFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'cover_image' => 'admin/images/no_image.jpg',
            'en' => [
                'title' => fake()->sentence,
                'description' => fake()->sentence,
                'slug' => fake()->unique()->slug,
                'meta_title' => fake()->sentence,
                'meta_description' => fake()->sentence,
            ],
            'bg' => [
                'title' => fake()->sentence,
                'description' => fake()->sentence,
                'slug' => fake()->unique()->slug,
                'meta_title' => fake()->sentence,
                'meta_description' => fake()->sentence,
            ],
        ];
    }
}
