<?php

return array(

    /*
    |--------------------------------------------------------------------------
    | Upload dir
    |--------------------------------------------------------------------------
    |
    | The dir where to store the images (relative from public)
    |
    */
    'dir' => ['storage/files'],

    /*
    |--------------------------------------------------------------------------
    | Filesystem disks (Flysytem)
    |--------------------------------------------------------------------------
    |
    | Define an array of Filesystem disks, which use Flysystem.
    | You can set extra options, example:
    |
    | 'my-disk' => [
    |        'URL' => url('to/disk'),
    |        'alias' => 'Local storage',
    |    ]
    */
    'disks' => [],

    /*
    |--------------------------------------------------------------------------
    | Routes group config
    |--------------------------------------------------------------------------
    |
    | The default group settings for the elFinder routes.
    |
    */

    'route' => [
        'prefix' => 'admin/filemanager',
        'middleware' => ['auth', 'web'], //Set to null to disable middleware filter
    ],

    /*
    |--------------------------------------------------------------------------
    | Access filter
    |--------------------------------------------------------------------------
    |
    | Filter callback to check the files
    |
    */

    'access' => 'Barryvdh\Elfinder\Elfinder::checkAccess',

    /*
    |--------------------------------------------------------------------------
    | Roots
    |--------------------------------------------------------------------------
    |
    | By default, the roots file is LocalFileSystem, with the above public dir.
    | If you want custom options, you can set your own roots below.
    |
    */

    'roots' => [
        [
            'driver' => 'LocalFileSystem',
            'path' => public_path('storage/files'),
            'URL' => env('APP_URL') . '/storage/files',
            'accessControl' => 'Barryvdh\Elfinder\Elfinder::checkAccess',
            'tmbSize' => 128,
            'tmbCrop' => false,
            'tmbBgColor' => '#ffffff',
        ]
    ],


    /*
    |--------------------------------------------------------------------------
    | Options
    |--------------------------------------------------------------------------
    |
    | These options are merged, together with 'roots' and passed to the Connector.
    | See https://github.com/Studio-42/elFinder/wiki/Connector-configuration-options-2.1
    |
    */

    'options' => [
        'tmbSize' => 128,
        'bind' => [
            'upload.pre mkdir.pre mkfile.pre rename.pre archive.pre ls.pre' => [
                'Plugin.Sanitizer.cmdPreprocess'
            ],
            'upload.presave paste.copyfrom' => [
                'Plugin.Sanitizer.onUpLoadPreSave'
            ],
            'upload.presave' => [
                'Plugin.AutoResize.onUpLoadPreSave'
            ]
        ],
        'plugin' => [
            'AutoResize' => [
                'enable' => true,
                'maxWidth'  => 1200,
                'maxHeight'  => 1200,
                'quality' => 90,
                'targetType' => IMG_GIF | IMG_JPG | IMG_PNG | IMG_WBMP
            ],
            'Sanitizer' => [
                'enable' => true,
                'targets'  => ['\\', '/', ':', '*', '?', '"', '<', '>', '|'],
                'replace'  => '-'
            ]
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Root Options
    |--------------------------------------------------------------------------
    |
    | These options are merged, together with every root by default.
    | See https://github.com/Studio-42/elFinder/wiki/Connector-configuration-options-2.1#root-options
    |
    */
    'root_options' => [],

);
