<?php

namespace App\View\Components\Admin;

use App\Forms\SelectList;
use Closure;
use Illuminate\View\Component;
use App\Models\Sections\Section;
use Illuminate\Contracts\View\View;
use App\Models\Sections\SectionType;
use Illuminate\Database\Eloquent\Model;

class NestableSectionsList extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(public Model $parent)
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.admin.nestable-sections-list', [
            'sectionTypes' => SectionType::all(),
            'sections' => Section::filterByParentIdAndType($this->parent->id, $this->parent::class)
                ->defaultOrder()
                ->get()
                ->toTree(),
            'sectionColors' => (new SelectList)->get('sections.colors')
        ]);
    }
}
